/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.item.nbt;

import com.mojang.serialization.DynamicOps;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.builder.AttachmentItemBuilder;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.api.item.nbt.AttachmentItemDataAccessor;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.index.ClientAttachmentIndex;
import com.tacz.guns.resource.index.CommonGunIndex;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_7225;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public interface GunItemDataAccessor
extends IGun {
    public static final String GUN_ID_TAG = "GunId";
    public static final String GUN_FIRE_MODE_TAG = "GunFireMode";
    public static final String GUN_HAS_BULLET_IN_BARREL = "HasBulletInBarrel";
    public static final String GUN_CURRENT_AMMO_COUNT_TAG = "GunCurrentAmmoCount";
    public static final String GUN_ATTACHMENT_BASE = "Attachment";
    public static final String GUN_EXP_TAG = "GunLevelExp";
    public static final String GUN_DUMMY_AMMO = "DummyAmmo";
    public static final String GUN_MAX_DUMMY_AMMO = "MaxDummyAmmo";
    public static final String GUN_ATTACHMENT_LOCK = "AttachmentLock";
    public static final String GUN_DISPLAY_ID_TAG = "GunDisplayId";
    public static final String LASER_COLOR_TAG = "LaserColor";
    public static final String GUN_OVERHEAT_TAG = "HeatAmount";
    public static final String GUN_OVERHEAT_LOCK_TAG = "OverHeated";

    @Override
    default public boolean useDummyAmmo(class_1799 gun) {
        class_2487 nbt = ((class_9279)gun.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        return nbt.method_10573(GUN_DUMMY_AMMO, 3);
    }

    @Override
    default public int getDummyAmmoAmount(class_1799 gun) {
        class_2487 nbt = ((class_9279)gun.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        return Math.max(0, nbt.method_10550(GUN_DUMMY_AMMO));
    }

    @Override
    default public void setDummyAmmoAmount(class_1799 gun, int amount) {
        gun.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, data -> data.method_57451(tag -> tag.method_10569(GUN_DUMMY_AMMO, Math.max(amount, 0))));
    }

    @Override
    default public void addDummyAmmoAmount(class_1799 gun, int amount) {
        if (!this.useDummyAmmo(gun)) {
            return;
        }
        int maxDummyAmmo = Integer.MAX_VALUE;
        if (this.hasMaxDummyAmmo(gun)) {
            maxDummyAmmo = this.getMaxDummyAmmoAmount(gun);
        }
        int dummyAmmo = Math.min(this.getDummyAmmoAmount(gun) + amount, maxDummyAmmo);
        gun.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, data -> data.method_57451(tag -> tag.method_10569(GUN_DUMMY_AMMO, Math.max(dummyAmmo, 0))));
    }

    @Override
    default public boolean hasMaxDummyAmmo(class_1799 gun) {
        class_2487 nbt = ((class_9279)gun.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        return nbt.method_10573(GUN_MAX_DUMMY_AMMO, 3);
    }

    @Override
    default public int getMaxDummyAmmoAmount(class_1799 gun) {
        class_2487 nbt = ((class_9279)gun.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        return Math.max(0, nbt.method_10550(GUN_MAX_DUMMY_AMMO));
    }

    @Override
    default public void setMaxDummyAmmoAmount(class_1799 gun, int amount) {
        gun.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, data -> data.method_57451(tag -> tag.method_10569(GUN_MAX_DUMMY_AMMO, Math.max(amount, 0))));
    }

    @Override
    default public boolean hasAttachmentLock(class_1799 gun) {
        class_2487 nbt = ((class_9279)gun.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        if (nbt.method_10573(GUN_ATTACHMENT_LOCK, 1)) {
            return nbt.method_10577(GUN_ATTACHMENT_LOCK);
        }
        return false;
    }

    @Override
    default public void setAttachmentLock(class_1799 gun, boolean lock) {
        gun.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, data -> data.method_57451(tag -> tag.method_10556(GUN_ATTACHMENT_LOCK, lock)));
    }

    @Override
    @Nonnull
    default public class_2960 getGunId(class_1799 gun) {
        class_2487 nbt = ((class_9279)gun.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        if (nbt.method_10573(GUN_ID_TAG, 8)) {
            class_2960 gunId = class_2960.method_12829((String)nbt.method_10558(GUN_ID_TAG));
            return Objects.requireNonNullElse(gunId, DefaultAssets.EMPTY_GUN_ID);
        }
        return DefaultAssets.EMPTY_GUN_ID;
    }

    @Override
    default public void setGunId(class_1799 gun, @Nullable class_2960 gunId) {
        gun.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, data -> data.method_57451(tag -> {
            if (gunId != null) {
                tag.method_10582(GUN_ID_TAG, gunId.toString());
            }
        }));
    }

    @Override
    @NotNull
    default public class_2960 getGunDisplayId(class_1799 gun) {
        class_2487 nbt = ((class_9279)gun.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        if (nbt.method_10573(GUN_DISPLAY_ID_TAG, 8)) {
            class_2960 gunDisplayId = class_2960.method_12829((String)nbt.method_10558(GUN_DISPLAY_ID_TAG));
            return Objects.requireNonNullElse(gunDisplayId, DefaultAssets.DEFAULT_GUN_DISPLAY_ID);
        }
        return DefaultAssets.DEFAULT_GUN_DISPLAY_ID;
    }

    @Override
    default public void setGunDisplayId(class_1799 gun, class_2960 displayId) {
        gun.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, data -> data.method_57451(tag -> {
            if (displayId != null) {
                tag.method_10582(GUN_DISPLAY_ID_TAG, displayId.toString());
            }
        }));
    }

    @Override
    default public int getLevel(class_1799 gun) {
        class_2487 nbt = ((class_9279)gun.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        if (nbt.method_10573(GUN_EXP_TAG, 3)) {
            return this.getLevel(nbt.method_10550(GUN_EXP_TAG));
        }
        return 0;
    }

    @Override
    default public int getExp(class_1799 gun) {
        class_2487 nbt = ((class_9279)gun.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        if (nbt.method_10573(GUN_EXP_TAG, 3)) {
            return nbt.method_10550(GUN_EXP_TAG);
        }
        return 0;
    }

    @Override
    default public int getExpToNextLevel(class_1799 gun) {
        int exp = this.getExp(gun);
        int level = this.getLevel(exp);
        if (level >= this.getMaxLevel()) {
            return 0;
        }
        int nextLevelExp = this.getExp(level + 1);
        return nextLevelExp - exp;
    }

    @Override
    default public int getExpCurrentLevel(class_1799 gun) {
        int exp = this.getExp(gun);
        int level = this.getLevel(exp);
        if (level <= 0) {
            return exp;
        }
        return exp - this.getExp(level - 1);
    }

    @Override
    default public FireMode getFireMode(class_1799 gun) {
        class_2487 nbt = ((class_9279)gun.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        if (nbt.method_10573(GUN_FIRE_MODE_TAG, 8)) {
            return FireMode.valueOf(nbt.method_10558(GUN_FIRE_MODE_TAG));
        }
        return FireMode.UNKNOWN;
    }

    @Override
    default public void setFireMode(class_1799 gun, @Nullable FireMode fireMode) {
        gun.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, data -> data.method_57451(tag -> {
            if (fireMode != null) {
                tag.method_10582(GUN_FIRE_MODE_TAG, fireMode.name());
                return;
            }
            tag.method_10582(GUN_FIRE_MODE_TAG, FireMode.UNKNOWN.name());
        }));
    }

    @Override
    default public int getCurrentAmmoCount(class_1799 gun) {
        class_2487 nbt = ((class_9279)gun.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        if (nbt.method_10573(GUN_CURRENT_AMMO_COUNT_TAG, 3)) {
            return nbt.method_10550(GUN_CURRENT_AMMO_COUNT_TAG);
        }
        return 0;
    }

    @Override
    default public void setCurrentAmmoCount(class_1799 gun, int ammoCount) {
        gun.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, data -> data.method_57451(tag -> tag.method_10569(GUN_CURRENT_AMMO_COUNT_TAG, Math.max(ammoCount, 0))));
    }

    @Override
    default public void reduceCurrentAmmoCount(class_1799 gun) {
        if (!this.useInventoryAmmo(gun)) {
            this.setCurrentAmmoCount(gun, this.getCurrentAmmoCount(gun) - 1);
        }
    }

    @Override
    @Nullable
    default public class_2487 getAttachmentTag(class_1799 gun, AttachmentType type) {
        String key;
        if (!this.allowAttachmentType(gun, type)) {
            return null;
        }
        class_2487 nbt = ((class_9279)gun.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        if (!nbt.method_10573(key = GUN_ATTACHMENT_BASE + type.name(), 10)) {
            return null;
        }
        class_2487 stack = nbt.method_10562(key);
        if (!stack.method_10573("components", 10)) {
            return null;
        }
        class_2487 components = stack.method_10562("components");
        if (!components.method_10545(class_9334.field_49628.toString())) {
            return null;
        }
        return components.method_10562(class_9334.field_49628.toString());
    }

    @Override
    default public void setAttachmentTag(class_1799 gun, AttachmentType type, class_2487 attachmentTag) {
        if (!this.allowAttachmentType(gun, type)) {
            return;
        }
        gun.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, data -> data.method_57451(tag -> {
            String key = GUN_ATTACHMENT_BASE + type.name();
            if (!tag.method_10573(key, 10)) {
                return;
            }
            class_2487 stack = tag.method_10562(key);
            if (!stack.method_10573("components", 10)) {
                return;
            }
            class_2487 components = stack.method_10562("components");
            if (!components.method_10545(class_9334.field_49628.toString())) {
                return;
            }
            components.method_10566(class_9334.field_49628.toString(), (class_2520)attachmentTag);
        }));
    }

    @Override
    @NotNull
    default public class_1799 getBuiltinAttachment(class_1799 gun, AttachmentType type) {
        Map<AttachmentType, class_2960> builtin;
        IGun iGun = IGun.getIGunOrNull(gun);
        if (iGun == null) {
            return class_1799.field_8037;
        }
        CommonGunIndex index = TimelessAPI.getCommonGunIndex(iGun.getGunId(gun)).orElse(null);
        if (index != null && (builtin = index.getGunData().getBuiltInAttachments()).containsKey((Object)type)) {
            return AttachmentItemBuilder.create().setId(builtin.get((Object)type)).build();
        }
        return class_1799.field_8037;
    }

    @Override
    @Nonnull
    default public class_1799 getAttachment(class_7225.class_7874 provider, class_1799 gun, AttachmentType type) {
        String key;
        if (!this.allowAttachmentType(gun, type)) {
            return class_1799.field_8037;
        }
        class_2487 nbt = ((class_9279)gun.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        if (nbt.method_10573(key = GUN_ATTACHMENT_BASE + type.name(), 10)) {
            return class_1799.field_24671.parse((DynamicOps)provider.method_57093((DynamicOps)class_2509.field_11560), (Object)nbt.method_10562(key)).result().orElse(class_1799.field_8037);
        }
        return class_1799.field_8037;
    }

    @Override
    @NotNull
    default public class_2960 getBuiltInAttachmentId(class_1799 gun, AttachmentType type) {
        Map<AttachmentType, class_2960> builtin;
        IGun iGun = IGun.getIGunOrNull(gun);
        if (iGun == null) {
            return DefaultAssets.EMPTY_ATTACHMENT_ID;
        }
        CommonGunIndex index = TimelessAPI.getCommonGunIndex(iGun.getGunId(gun)).orElse(null);
        if (index != null && (builtin = index.getGunData().getBuiltInAttachments()).containsKey((Object)type)) {
            return builtin.get((Object)type);
        }
        return DefaultAssets.EMPTY_ATTACHMENT_ID;
    }

    @Override
    @Nonnull
    default public class_2960 getAttachmentId(class_1799 gun, AttachmentType type) {
        class_2487 attachmentTag = this.getAttachmentTag(gun, type);
        if (attachmentTag != null) {
            return AttachmentItemDataAccessor.getAttachmentIdFromTag(attachmentTag);
        }
        return DefaultAssets.EMPTY_ATTACHMENT_ID;
    }

    @Override
    default public void installAttachment(class_7225.class_7874 provider, @Nonnull class_1799 gun, @Nonnull class_1799 attachment) {
        if (!this.allowAttachment(gun, attachment)) {
            return;
        }
        IAttachment iAttachment = IAttachment.getIAttachmentOrNull(attachment);
        if (iAttachment == null) {
            return;
        }
        gun.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, data -> data.method_57451(tag -> {
            String key = GUN_ATTACHMENT_BASE + iAttachment.getType(attachment).name();
            class_2520 attachmentTag = provider == null ? (class_2520)class_1799.field_24671.encodeStart((DynamicOps)class_2509.field_11560, (Object)attachment).getOrThrow() : attachment.method_57375(provider);
            tag.method_10566(key, attachmentTag);
        }));
    }

    @Override
    default public void unloadAttachment(class_7225.class_7874 provider, @Nonnull class_1799 gun, AttachmentType type) {
        if (!this.allowAttachmentType(gun, type)) {
            return;
        }
        gun.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, data -> data.method_57451(tag -> {
            String key = GUN_ATTACHMENT_BASE + type.name();
            tag.method_10566(key, class_1799.field_8037.method_57375(provider));
        }));
    }

    @Override
    default public float getAimingZoom(class_1799 gunItem) {
        float zoom = 1.0f;
        class_2960 scopeId = this.getAttachmentId(gunItem, AttachmentType.SCOPE);
        boolean builtin = false;
        if (scopeId.equals((Object)DefaultAssets.EMPTY_ATTACHMENT_ID)) {
            scopeId = this.getBuiltInAttachmentId(gunItem, AttachmentType.SCOPE);
            builtin = true;
        }
        if (!DefaultAssets.isEmptyAttachmentId(scopeId)) {
            class_2487 attachmentTag = this.getAttachmentTag(gunItem, AttachmentType.SCOPE);
            int zoomNumber = builtin ? 0 : AttachmentItemDataAccessor.getZoomNumberFromTag(attachmentTag);
            float[] zooms = TimelessAPI.getClientAttachmentIndex(scopeId).map(ClientAttachmentIndex::getZoom).orElse(null);
            if (zooms != null) {
                zoom = zooms[zoomNumber % zooms.length];
            }
        } else {
            zoom = TimelessAPI.getGunDisplay(gunItem).map(GunDisplayInstance::getIronZoom).orElse(Float.valueOf(1.0f)).floatValue();
        }
        return zoom;
    }

    @Override
    default public boolean hasBulletInBarrel(class_1799 gun) {
        class_2487 nbt = ((class_9279)gun.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        if (nbt.method_10573(GUN_HAS_BULLET_IN_BARREL, 1)) {
            return nbt.method_10577(GUN_HAS_BULLET_IN_BARREL);
        }
        return false;
    }

    @Override
    default public void setBulletInBarrel(class_1799 gun, boolean bulletInBarrel) {
        gun.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, data -> data.method_57451(tag -> tag.method_10556(GUN_HAS_BULLET_IN_BARREL, bulletInBarrel)));
    }

    @Override
    default public boolean hasCustomLaserColor(class_1799 gun) {
        class_2487 nbt = ((class_9279)gun.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        return nbt.method_10573(LASER_COLOR_TAG, 3);
    }

    @Override
    default public int getLaserColor(class_1799 gun) {
        class_2487 nbt = ((class_9279)gun.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        if (!this.hasCustomLaserColor(gun)) {
            return 0xFF0000;
        }
        return nbt.method_10550(LASER_COLOR_TAG);
    }

    @Override
    default public void setLaserColor(class_1799 gun, int color) {
        gun.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, data -> data.method_57451(tag -> tag.method_10569(LASER_COLOR_TAG, color)));
    }

    @Override
    default public boolean hasHeatData(class_1799 gun) {
        return ((class_9279)gun.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461().method_10573(GUN_OVERHEAT_TAG, 5);
    }

    @Override
    default public boolean isOverheatLocked(class_1799 gun) {
        return ((class_9279)gun.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461().method_10577(GUN_OVERHEAT_LOCK_TAG);
    }

    @Override
    default public void setOverheatLocked(class_1799 gun, boolean locked) {
        gun.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, data -> data.method_57451(tag -> tag.method_10556(GUN_OVERHEAT_LOCK_TAG, locked)));
    }

    @Override
    default public float getHeatAmount(class_1799 gun) {
        if (this.hasHeatData(gun)) {
            return ((class_9279)gun.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461().method_10583(GUN_OVERHEAT_TAG);
        }
        return 0.0f;
    }

    @Override
    default public void setHeatAmount(class_1799 gun, float amount) {
        gun.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, data -> data.method_57451(tag -> tag.method_10548(GUN_OVERHEAT_TAG, amount >= 0.0f ? amount : 0.0f)));
    }

    @Override
    default public float lerpRPM(class_1799 gun) {
        return TimelessAPI.getCommonGunIndex(this.getGunId(gun)).map(index -> index.getGunData().getHeatData()).map(heatData -> {
            float heatPercentage = this.getHeatAmount(gun) / heatData.getHeatMax();
            return Float.valueOf(class_3532.method_16439((float)heatPercentage, (float)heatData.getMinRpmMod(), (float)heatData.getMaxRpmMod()));
        }).orElse(Float.valueOf(1.0f)).floatValue();
    }

    @Override
    default public float lerpInaccuracy(class_1799 gun) {
        return TimelessAPI.getCommonGunIndex(this.getGunId(gun)).map(index -> index.getGunData().getHeatData()).map(heatData -> {
            float heatPercentage = this.getHeatAmount(gun) / heatData.getHeatMax();
            return Float.valueOf(class_3532.method_16439((float)heatPercentage, (float)heatData.getMinInaccuracy(), (float)heatData.getMaxInaccuracy()));
        }).orElse(Float.valueOf(1.0f)).floatValue();
    }
}

