/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gui.overlay;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.config.client.RenderConfig;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.GunHeatData;
import java.text.DecimalFormat;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5253;
import net.minecraft.class_746;
import net.minecraft.class_9779;

public class HeatBarOverlay {
    private static final class_2960 HEATBASE = class_2960.method_60655((String)"tacz", (String)"textures/hud/heat_base.png");
    private static final DecimalFormat HEAT_FORMAT_PERCENT = new DecimalFormat("0.0%");
    private static float heatScale = 0.25f;

    public static void render(class_332 graphics, class_9779 deltaTracker) {
        int width = graphics.method_51421();
        int height = graphics.method_51443();
        if (!((Boolean)RenderConfig.GUN_HUD_ENABLE.get()).booleanValue()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (!(player instanceof IClientPlayerGunOperator)) {
            return;
        }
        class_1799 stack = player.method_6047();
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)class_17922;
        class_2960 gunId = iGun.getGunId(stack);
        GunData gunData = TimelessAPI.getClientGunIndex(gunId).map(ClientGunIndex::getGunData).orElse(null);
        GunDisplayInstance display = TimelessAPI.getGunDisplay(stack).orElse(null);
        if (gunData == null || display == null) {
            return;
        }
        class_4587 poseStack = graphics.method_51448();
        if (gunData.getHeatData() != null && iGun.hasHeatData(stack)) {
            poseStack.method_22903();
            GunHeatData heatData = gunData.getHeatData();
            float percent = iGun.getHeatAmount(stack) / heatData.getHeatMax();
            float scaleValue = iGun.getHeatAmount(stack) / heatData.getHeatMax() / 8.0f + 0.75f;
            if (heatScale < scaleValue) {
                heatScale += 0.05f;
            }
            if (heatScale > scaleValue) {
                heatScale -= 0.025f;
            }
            if ((double)heatScale > (double)scaleValue - 0.03 && (double)heatScale < (double)scaleValue + 0.055) {
                heatScale = scaleValue;
            }
            poseStack.method_22905(heatScale, heatScale, 1.0f);
            boolean locked = iGun.isOverheatLocked(stack);
            int tickCount = mc.field_1705.method_1738();
            HeatBarOverlay.renderOverheat(percent, graphics, (int)((float)width / heatScale), (int)((float)height / heatScale), locked, tickCount);
            poseStack.method_22909();
        }
    }

    public static void renderOverheat(float heatPercentage, class_332 pGraphics, int w, int h, boolean locked, int tickCount) {
        String percentString;
        int barColor = HeatBarOverlay.getHeatColor(heatPercentage, locked, tickCount);
        pGraphics.method_25294(w / 2 - 30, h / 2 + 30, w / 2 - 30 + (int)(heatPercentage * 60.0f), h / 2 + 34, barColor);
        if (locked) {
            if (tickCount % 20 < 10) {
                pGraphics.method_51422(1.0f, 0.1f, 0.1f, 1.0f);
            } else {
                pGraphics.method_51422(1.0f, 1.0f, 0.1f, 1.0f);
            }
        }
        pGraphics.method_25290(HEATBASE, w / 2 - 64, h / 2 - 44, 0.0f, 0.0f, 128, 128, 128, 128);
        pGraphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        class_327 font = class_310.method_1551().field_39924;
        String string = percentString = locked ? "!OVERHEAT!" : HEAT_FORMAT_PERCENT.format(heatPercentage);
        int color = locked ? (tickCount % 20 < 10 ? -65536 : -256) : -1;
        pGraphics.method_51433(font, percentString, w / 2 - font.method_1727(percentString) / 2, h / 2 + 38, color, true);
    }

    public static int getHeatColor(float percent, boolean locked, int tickCount) {
        if (locked) {
            return tickCount % 20 < 10 ? -1610678272 : -1610612992;
        }
        if ((double)percent < 0.4) {
            return -1610612737;
        }
        int color = (double)percent <= 0.65 ? class_5253.class_5254.method_48780((float)(percent * 4.0f - 1.6f), (int)-1610612737, (int)-1610612992) : class_5253.class_5254.method_48780((float)((percent - 0.65f) / 0.35f), (int)-1610612992, (int)-1610678272);
        return color;
    }
}

