package cn.sh1rocu.tacz.api.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_2535;
import net.minecraft.class_636;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public abstract class ClientPlayerNetworkEvent extends BaseEvent {
    private final class_636 multiPlayerGameMode;
    private final class_746 player;
    private final class_2535 connection;

    public static final Event<LoggingOutCallback> LOGGING_OUT = EventFactory.createArrayBacked(LoggingOutCallback.class, callbacks -> event -> {
        for (LoggingOutCallback callback : callbacks) {
            callback.post(event);
        }
    });

    public static final Event<CloneCallback> CLONE = EventFactory.createArrayBacked(CloneCallback.class, callbacks -> event -> {
        for (CloneCallback callback : callbacks) {
            callback.post(event);
        }
    });

    public interface LoggingOutCallback {
        void post(LoggingOut event);
    }

    public interface CloneCallback {
        void post(Clone event);
    }

    protected ClientPlayerNetworkEvent(final class_636 multiPlayerGameMode, final class_746 player, final class_2535 connection) {
        this.multiPlayerGameMode = multiPlayerGameMode;
        this.player = player;
        this.connection = connection;
    }

    public class_636 getMultiPlayerGameMode() {
        return multiPlayerGameMode;
    }

    public class_746 getPlayer() {
        return player;
    }

    public class_2535 getConnection() {
        return connection;
    }

    public static class LoggingOut extends ClientPlayerNetworkEvent {
        public LoggingOut(@Nullable final class_636 controller, @Nullable final class_746 player, @Nullable final class_2535 networkManager) {
            super(controller, player, networkManager);
        }

        @Nullable
        @Override
        public class_636 getMultiPlayerGameMode() {
            return super.getMultiPlayerGameMode();
        }

        @Nullable
        @Override
        public class_746 getPlayer() {
            return super.getPlayer();
        }

        @Nullable
        @Override
        public class_2535 getConnection() {
            return super.getConnection();
        }
    }

    public static class Clone extends ClientPlayerNetworkEvent {
        private final class_746 oldPlayer;

        public Clone(final class_636 pc, final class_746 oldPlayer, final class_746 newPlayer, final class_2535 networkManager) {
            super(pc, newPlayer, networkManager);
            this.oldPlayer = oldPlayer;
        }

        public class_746 getOldPlayer() {
            return oldPlayer;
        }

        public class_746 getNewPlayer() {
            return super.getPlayer();
        }

        @Override
        public class_746 getPlayer() {
            return super.getPlayer();
        }
    }
}
