package cn.sh1rocu.tacz.api.event;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1113;
import net.minecraft.class_1140;
import net.minecraft.class_4224;

@Environment(EnvType.CLIENT)
public class PlaySoundSourceEvent extends BaseEvent {
    private final class_1140 engine;
    private final String name;
    private final class_1113 sound;
    private final class_4224 channel;

    public PlaySoundSourceEvent(class_1140 engine, class_1113 sound, class_4224 channel) {
        this.engine = engine;
        this.name = sound.method_4775().method_12832();
        this.sound = sound;
        this.channel = channel;
    }

    public static final Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> event -> {
        for (Callback callback : callbacks) {
            callback.post(event);
        }
    });

    public class_1140 getEngine() {
        return engine;
    }

    public class_1113 getSound() {
        return sound;
    }

    public class_4224 getChannel() {
        return channel;
    }

    public String getName() {
        return name;
    }

    public interface Callback {
        void post(PlaySoundSourceEvent event);
    }
}
