package com.tacz.guns.api.item.nbt;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.item.IBlock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import java.util.Objects;

public interface BlockItemDataAccessor extends IBlock {
    String BLOCK_ID = "BlockId";

    @Override
    @Nonnull
    default class_2960 getBlockId(class_1799 block) {
        class_2487 nbt = block.method_57825(class_9334.field_49628, class_9279.field_49302).method_57461();
        if (nbt.method_10573(BLOCK_ID, class_2520.field_33258)) {
            class_2960 gunId = class_2960.method_12829(nbt.method_10558(BLOCK_ID));
            return Objects.requireNonNullElse(gunId, DefaultAssets.EMPTY_BLOCK_ID);
        }
        return DefaultAssets.EMPTY_BLOCK_ID;
    }

    @Override
    default void setBlockId(class_1799 block, @Nullable class_2960 blockId) {
        block.method_57368(class_9334.field_49628, class_9279.field_49302, data -> data.method_57451(tag -> {
            if (blockId != null) {
                tag.method_10582(BLOCK_ID, blockId.toString());
                return;
            }
            tag.method_10582(BLOCK_ID, DefaultAssets.EMPTY_BLOCK_ID.toString());
        }));
    }

}