package com.tacz.guns.client.event;

import cn.sh1rocu.tacz.api.event.RenderTickEvent;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tacz.guns.GunMod;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.animation.statemachine.AnimationStateContext;
import com.tacz.guns.api.client.animation.statemachine.AnimationStateMachine;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ReloadState;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.gui.GunRefitScreen;
import com.tacz.guns.client.renderer.crosshair.CrosshairType;
import com.tacz.guns.compat.shouldersurfing.ShoulderSurfingCompat;
import com.tacz.guns.config.client.RenderConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_636;
import net.minecraft.class_746;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;


@Environment(EnvType.CLIENT)
public class RenderCrosshairEvent {
    private static final class_2960 HIT_ICON = class_2960.method_60655(GunMod.MOD_ID, "textures/crosshair/hit/hit_marker.png");
    private static final long KEEP_TIME = 300;
    private static boolean isRefitScreen = false;
    private static long hitTimestamp = -1L;
    private static long killTimestamp = -1L;
    private static long headShotTimestamp = -1L;

    /**
     * 当玩家手上拿着枪时，播放特定动画、或瞄准时需要隐藏准心
     */
    public static void onRenderOverlay(class_332 guiGraphics, class_1041 window, class_9779 deltaTracker, CallbackInfo ci) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (!IGun.mainHandHoldGun(player)) {
            return;
        }

        // 全面替换成自己的
        ci.cancel();

        // 击中显示
        renderHitMarker(guiGraphics, window);
        // 换弹进行时取消准心渲染
        ReloadState reloadState = IGunOperator.fromLivingEntity(player).getSynReloadState();
        if (reloadState.getStateType().isReloading()) {
            return;
        }
        // 打开枪械改装界面的时候，取消准心渲染
        if (isRefitScreen) {
            return;
        }
        // 播放的动画需要隐藏准心时，取消准心渲染
        class_1799 stack = player.method_6047();
        if (!(stack.method_7909() instanceof IGun)) {
            return;
        }

        IClientPlayerGunOperator playerGunOperator = IClientPlayerGunOperator.fromLocalPlayer(player);
        TimelessAPI.getGunDisplay(stack).ifPresent(gunIndex -> {
            // 瞄准快要完成时，取消准心渲染
            if (playerGunOperator.getClientAimingProgress(deltaTracker.method_60637(false)) > 0.9) {
                // 枪包可以强制显示准星
                boolean forceShow = gunIndex.isShowCrosshair();
                // 越肩视角可以强制显示准星
                boolean shoulderSurfingForceShow = ShoulderSurfingCompat.showCrosshair();
                // 两个强制都没有时，那么才允许隐藏
                if (!forceShow && !shoulderSurfingForceShow) {
                    return;
                }
            }

            AnimationStateMachine<?> animationStateMachine = gunIndex.getAnimationStateMachine();
            AnimationStateContext context = animationStateMachine.getContext();
            if (context == null || !context.shouldHideCrossHair()) {
                renderCrosshair(guiGraphics, window);
            }
        });
    }

    public static void onRenderTick(RenderTickEvent event) {
        // 奇迹的是，RenderGameOverlayEvent.PreLayer 事件中，screen 还未被赋值...
        isRefitScreen = class_310.method_1551().field_1755 instanceof GunRefitScreen;
    }

    private static void renderCrosshair(class_332 graphics, class_1041 window) {
        class_315 options = class_310.method_1551().field_1690;
        // 越肩视角可以强制显示准星
        boolean shoulderSurfingForceShow = ShoulderSurfingCompat.showCrosshair();
        if (!options.method_31044().method_31034() && !shoulderSurfingForceShow) {
            return;
        }
        if (options.field_1842) {
            return;
        }
        class_636 gameMode = class_310.method_1551().field_1761;
        if (gameMode == null) {
            return;
        }
        if (gameMode.method_2920() == class_1934.field_9219) {
            return;
        }
        int width = window.method_4486();
        int height = window.method_4502();

        class_2960 location = CrosshairType.getTextureLocation(RenderConfig.CROSSHAIR_TYPE.get());

        RenderSystem.enableBlend();
        RenderSystem.blendFunc(GlStateManager.class_4535.SRC_ALPHA, GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor(1F, 1F, 1F, 0.9f);
        float x = width / 2f - 8;
        float y = height / 2f - 8;
        graphics.method_25290(location, (int) x, (int) y, 0, 0, 16, 16, 16, 16);
    }

    private static void renderHitMarker(class_332 graphics, class_1041 window) {
        long remainHitTime = System.currentTimeMillis() - hitTimestamp;
        long remainKillTime = System.currentTimeMillis() - killTimestamp;
        long remainHeadShotTime = System.currentTimeMillis() - headShotTimestamp;
        float offset = RenderConfig.HIT_MARKET_START_POSITION.get().floatValue();
        float fadeTime;

        if (remainKillTime > KEEP_TIME) {
            if (remainHitTime > KEEP_TIME) {
                return;
            } else {
                fadeTime = remainHitTime;
            }
        } else {
            // 最大位移为 4 像素
            offset += (remainKillTime * 4f) / KEEP_TIME;
            fadeTime = remainKillTime;
        }

        int width = window.method_4486();
        int height = window.method_4502();
        float x = width / 2f - 8;
        float y = height / 2f - 8;

        RenderSystem.enableBlend();
        RenderSystem.blendFunc(GlStateManager.class_4535.SRC_ALPHA, GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        if (remainHeadShotTime > KEEP_TIME) {
            RenderSystem.setShaderColor(1F, 1F, 1F, 1 - fadeTime / KEEP_TIME);
        } else {
            RenderSystem.setShaderColor(1F, 0, 0, 1 - fadeTime / KEEP_TIME);
        }

        graphics.method_25290(HIT_ICON, (int) (x - offset), (int) (y - offset), 0, 0, 8, 8, 16, 16);
        graphics.method_25290(HIT_ICON, (int) (x + 8 + offset), (int) (y - offset), 8, 0, 8, 8, 16, 16);
        graphics.method_25290(HIT_ICON, (int) (x - offset), (int) (y + 8 + offset), 0, 8, 8, 8, 16, 16);
        graphics.method_25290(HIT_ICON, (int) (x + 8 + offset), (int) (y + 8 + offset), 8, 8, 8, 8, 16, 16);
    }

    public static void markHitTimestamp() {
        RenderCrosshairEvent.hitTimestamp = System.currentTimeMillis();
    }

    public static void markKillTimestamp() {
        RenderCrosshairEvent.killTimestamp = System.currentTimeMillis();
    }

    public static void markHeadShotTimestamp() {
        RenderCrosshairEvent.headShotTimestamp = System.currentTimeMillis();
    }
}
