package com.tacz.guns.client.gameplay;

import cn.sh1rocu.tacz.api.mixin.ForcePoseInjection;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.network.message.ClientMessagePlayerCrawl;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_4050;
import net.minecraft.class_746;

public class LocalPlayerCrawl {
    /**
     * 冷却时间为 10 tick
     */
    private static final int COOLDOWN_TICKS = 10;
    private final class_746 player;
    private boolean isCrawling = false;
    private int crawCooldownTicks = 0;

    public LocalPlayerCrawl(class_746 player) {
        this.player = player;
    }

    public void crawl(boolean isCrawl) {
        // 持枪才能按键趴下
        class_1799 mainHandItem = player.method_6047();
        if (!(mainHandItem.method_7909() instanceof IGun iGun)) {
            return;
        }
        // 不允许趴下的武器
        if (!iGun.isCanCrawl(mainHandItem)) {
            return;
        }
        // 冷却时间没到，不执行
        if (crawCooldownTicks > 0) {
            return;
        }
        if (player.method_7325() || player.method_5765() || !player.method_24828()) {
            return;
        }
        class_2960 gunId = iGun.getGunId(mainHandItem);
        TimelessAPI.getClientGunIndex(gunId).ifPresent(gunIndex -> {
            this.isCrawling = isCrawl;
            this.crawCooldownTicks = COOLDOWN_TICKS;
            ClientPlayNetworking.send(new ClientMessagePlayerCrawl(isCrawl));
        });
    }

    public void tickCrawl() {
        if (crawCooldownTicks > 0) {
            crawCooldownTicks--;
        }
        // 持枪才能按键趴下
        class_1799 mainHandItem = player.method_6047();
        if (!(mainHandItem.method_7909() instanceof IGun iGun)) {
            isCrawling = false;
            this.setCrawlPose();
            return;
        }
        // 不允许趴下的武器，则取消趴下状态
        if (!iGun.isCanCrawl(mainHandItem)) {
            isCrawling = false;
            this.setCrawlPose();
            return;
        }
        // 如果获取不到 gunIndex，则取消趴下状态
        class_2960 gunId = iGun.getGunId(mainHandItem);
        if (TimelessAPI.getCommonGunIndex(gunId).isEmpty()) {
            isCrawling = false;
            this.setCrawlPose();
            return;
        }
        // 如果玩家是观察者模型、骑乘、跳跃、在游泳、不在地上，取消
        if (player.method_7325() || player.method_5765() || player.field_6282 || player.method_5681() || !player.method_24828()) {
            isCrawling = false;
            this.setCrawlPose();
            return;
        }
        this.setCrawlPose();
    }

    public boolean isCrawling() {
        return isCrawling;
    }

    private void setCrawlPose() {
        if (isCrawling) {
            ((ForcePoseInjection) player).tacz$setForcedPose(class_4050.field_18079);
        } else {
            ((ForcePoseInjection) player).tacz$setForcedPose(null);
        }
    }
}
