package com.tacz.guns.client.input;

import cn.sh1rocu.tacz.api.event.InputEvent;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.config.client.KeyConfig;
import com.tacz.guns.config.sync.SyncConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_746;
import org.lwjgl.glfw.GLFW;

import static com.tacz.guns.util.InputExtraCheck.isInGame;

@Environment(EnvType.CLIENT)
public class CrawlKey {
    public static final class_304 CRAWL_KEY = new class_304("key.tacz.crawl.desc",
            class_3675.class_307.field_1668,
            GLFW.GLFW_KEY_C,
            "key.category.tacz");

    public static void onCrawlPress(InputEvent.Key event) {
        if (isInGame() && CRAWL_KEY.method_1417(event.getKey(), event.getScanCode())) {
            if (!SyncConfig.ENABLE_CRAWL.get()) {
                return;
            }
            class_746 player = class_310.method_1551().field_1724;
            if (player == null || player.method_7325() || player.method_5765()) {
                return;
            }
            if (!(player instanceof IClientPlayerGunOperator operator)) {
                return;
            }
            if (player.method_6047().method_7909() instanceof IGun iGun) {
                // 如果不允许下蹲，则禁止进行下蹲
                if (!iGun.isCanCrawl(player.method_6047())) {
                    IClientPlayerGunOperator.fromLocalPlayer(player).crawl(false);
                    return;
                }
                boolean action = true;
                if (!KeyConfig.HOLD_TO_CRAWL.get()) {
                    action = !operator.isCrawl();
                }
                if (event.getAction() == GLFW.GLFW_PRESS) {
                    IClientPlayerGunOperator.fromLocalPlayer(player).crawl(action);
                }
                if (KeyConfig.HOLD_TO_CRAWL.get() && event.getAction() == GLFW.GLFW_RELEASE) {
                    IClientPlayerGunOperator.fromLocalPlayer(player).crawl(false);
                }
            }
        }
    }

    public static boolean onCrawlControllerPress(boolean isPress) {
        if (!isInGame()) {
            return false;
        }
        if (!SyncConfig.ENABLE_CRAWL.get()) {
            return false;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null || player.method_7325() || player.method_5765()) {
            return false;
        }
        if (!(player instanceof IClientPlayerGunOperator operator)) {
            return false;
        }
        if (!IGun.mainHandHoldGun(player)) {
            return false;
        }
        boolean action = true;
        if (!KeyConfig.HOLD_TO_CRAWL.get()) {
            action = !operator.isCrawl();
        }
        if (isPress) {
            IClientPlayerGunOperator.fromLocalPlayer(player).crawl(action);
            return true;
        }
        if (KeyConfig.HOLD_TO_CRAWL.get()) {
            IClientPlayerGunOperator.fromLocalPlayer(player).crawl(false);
            return true;
        }
        return false;
    }
}
