package com.tacz.guns.client.renderer.entity;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.client.model.BedrockAmmoModel;
import com.tacz.guns.client.model.bedrock.BedrockModel;
import com.tacz.guns.client.renderer.item.GunItemRendererWrapper;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.InternalAssetLoader;
import com.tacz.guns.config.client.RenderConfig;
import com.tacz.guns.entity.EntityKineticBullet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_897;

public class EntityBulletRenderer extends class_897<EntityKineticBullet> {
    public EntityBulletRenderer(class_5617.class_5618 pContext) {
        super(pContext);
    }

    public static Optional<BedrockModel> getModel() {
        return InternalAssetLoader.getBedrockModel(InternalAssetLoader.DEFAULT_BULLET_MODEL);
    }

    @Override
    public void render(EntityKineticBullet bullet, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        class_2960 gunId = bullet.getGunId();
        class_2960 gunDisplayId = bullet.getGunDisplayId();
        Optional<GunDisplayInstance> display = TimelessAPI.getGunDisplay(gunDisplayId, gunId);
        if (display.isEmpty()) {
            return;
        }
        float @Nullable [] tracerColor = bullet.getTracerColorOverride().orElse(display.get().getTracerColor());
        class_2960 ammoId = bullet.getAmmoId();
        TimelessAPI.getClientAmmoIndex(ammoId).ifPresent(ammoIndex -> {
            BedrockAmmoModel ammoEntityModel = ammoIndex.getAmmoEntityModel();
            class_2960 textureLocation = ammoIndex.getAmmoEntityTextureLocation();
            if (ammoEntityModel != null && textureLocation != null) {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(class_3532.method_16439(partialTicks, bullet.field_5982, bullet.method_36454()) - 180.0F));
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(class_3532.method_16439(partialTicks, bullet.field_6004, bullet.method_36455())));
                poseStack.method_22903();
                poseStack.method_22904(0, 1.5, 0);
                poseStack.method_22905(-1, -1, 1);
                ammoEntityModel.render(poseStack, class_811.field_4318, class_1921.method_23689(textureLocation), packedLight, class_4608.field_21444);
                poseStack.method_22909();
            }

            // 曳光弹发光
            if (bullet.isTracerAmmo()) {
                float[] actualTracerColor = Objects.requireNonNullElse(tracerColor, ammoIndex.getTracerColor());
                renderTracerAmmo(bullet, actualTracerColor, partialTicks, poseStack, packedLight);
            }
        });
    }

    public void renderTracerAmmo(EntityKineticBullet bullet, float[] tracerColor, float partialTicks, class_4587 poseStack, int packedLight) {
        getModel().ifPresent(model -> {
            class_1297 shooter = bullet.method_24921();
            if (shooter == null) {
                return;
            }
            boolean isFirstPerson = this.field_4676.field_4692.method_31044().method_31034() && shooter instanceof class_746;
            if (isFirstPerson && !RenderConfig.FIRST_PERSON_BULLET_TRACER_ENABLE.get()) {
                return;
            }
            poseStack.method_22903();
            {
                float width = 0.005f;
                class_243 bulletPosition = bullet.method_30950(partialTicks);
                double trailLength = 0.85 * bullet.method_18798().method_1033();
                double disToEye = bulletPosition.method_1022(shooter.method_5836(partialTicks));
                trailLength = Math.min(trailLength, disToEye * 0.8);

                if (isFirstPerson) {
                    // 第一人称渲染自己的曳光弹的时候需要应用偏移
                    class_4184 camera = class_310.method_1551().field_1773.method_19418();
                    Vector3f offset = bullet.getFirstPersonRenderOffset();
                    if (offset == null) {
                        offset = new Vector3f(GunItemRendererWrapper.muzzleRenderOffset);
                        bullet.setCameraXRot(camera.method_19329());
                        bullet.setCameraYRot(camera.method_19330());
                        bullet.setFirstPersonRenderOffset(offset);
                    }
                    // 按照生存时间减少曳光弹的偏移，避免渲染位置距离落点太远
                    double offsetReducer = Math.max(0, (50 - disToEye)) / 50;
                    // 摄像机旋转
                    poseStack.method_22907(class_7833.field_40715.rotationDegrees(bullet.getCameraYRot() + 180f));
                    poseStack.method_22907(class_7833.field_40713.rotationDegrees(bullet.getCameraXRot()));
                    // 应用偏移
                    poseStack.method_22904(offset.x * offsetReducer, offset.y * offsetReducer, offset.z * offsetReducer);
                    // 逆转摄像机旋转
                    poseStack.method_22907(class_7833.field_40714.rotationDegrees(bullet.getCameraXRot()));
                    poseStack.method_22907(class_7833.field_40716.rotationDegrees(bullet.getCameraYRot() + 180f));
                }
                // 说是 override 其实默认值是 1
                // 所以这里直接乘也没关系
                width *= bullet.getTracerSizeOverride();
                width *= (float) Math.max(1.0, disToEye / 3.5);
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(class_3532.method_16439(partialTicks, bullet.field_5982, bullet.method_36454()) - 180.0F));
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(class_3532.method_16439(partialTicks, bullet.field_6004, bullet.method_36455())));
                poseStack.method_22904(0, isFirstPerson ? 0 : -0.2, trailLength / 2.0);
                poseStack.method_22905(width, width, (float) trailLength);
                // 距离两格外才渲染，只在前 5 tick 判定
                double bulletDistance = bulletPosition.method_1022(shooter.method_33571());
                if (bullet.field_6012 >= 5 || bulletDistance > 2) {
                    class_1921 type = class_1921.method_23018(InternalAssetLoader.DEFAULT_BULLET_TEXTURE, 15, 15);
                    model.render(poseStack, class_811.field_4315, type, packedLight, class_4608.field_21444,
                            tracerColor[0], tracerColor[1], tracerColor[2], 1);
                }
            }
            poseStack.method_22909();
        });
    }

    @Override
    protected int getBlockLightLevel(@NotNull EntityKineticBullet entityBullet, @NotNull class_2338 blockPos) {
        return 15;
    }

    @Override
    public boolean shouldRender(EntityKineticBullet bullet, class_4604 camera, double pCamX, double pCamY, double pCamZ) {
        class_238 aabb = bullet.method_5830().method_1014(0.5);
        if (aabb.method_1013() || aabb.method_995() == 0) {
            aabb = new class_238(bullet.method_23317() - 2.0, bullet.method_23318() - 2.0, bullet.method_23321() - 2.0, bullet.method_23317() + 2.0, bullet.method_23318() + 2.0, bullet.method_23321() + 2.0);
        }
        return camera.method_23093(aabb);
    }

    @Override
    public class_2960 getTextureLocation(@NotNull EntityKineticBullet entity) {
        return null;
    }
}
