package com.tacz.guns.crafting.result;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.tacz.guns.GunMod;
import com.tacz.guns.resource.pojo.data.recipe.GunResult;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import com.tacz.guns.resource.pojo.data.block.TabConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GunSmithTableResult {
    public static final Codec<GunSmithTableResult> CODEC = Codec.of(GunSmithTableResult::encode, GunSmithTableResult::decode);
    public static final class_9139<class_9129, GunSmithTableResult> STREAM_CODEC = class_9139.method_56435(
            class_1799.field_49268, GunSmithTableResult::getResult,
            class_2960.field_48267, GunSmithTableResult::getGroup,
            GunSmithTableResult::new
    );

    public static <T> DataResult<T> encode(GunSmithTableResult input, DynamicOps<T> ops, T prefix) {
        throw new UnsupportedOperationException();
    }

    public static <T> DataResult<Pair<GunSmithTableResult, T>> decode(DynamicOps<T> ops, T input) {
        return ops.getMap(input).map(map -> {
            String typeName = Codec.STRING.fieldOf("type").decode(ops, map).getOrThrow();
            int count = Codec.INT.optionalFieldOf("count", 1).decode(ops, map).getOrThrow();
            class_2487 extraTag = class_2487.field_25128.optionalFieldOf("nbt", null).decode(ops, map).getOrThrow();
            class_2960 tabOverride = Codec.STRING.optionalFieldOf("group").decode(ops, map).getOrThrow()
                    .map(raw -> raw.contains(":") ? raw : GunMod.MOD_ID + ":" + raw)
                    .map(class_2960::method_12829).orElse(null);

            GunSmithTableResult result;
            switch (typeName) {
                case GunSmithTableResult.GUN,
                     GunSmithTableResult.AMMO,
                     GunSmithTableResult.ATTACHMENT -> {
                    class_2960 id = class_2960.field_25139.fieldOf("id").decode(ops, map).getOrThrow();
                    RawGunTableResult raw = new RawGunTableResult(typeName, id, count);
                    if (extraTag != null) raw.setNbt(extraTag);
                    if (typeName.equals(GunSmithTableResult.GUN)) {
                        GunResult.CODEC.parse(ops, input).result().ifPresent(raw::setExtraData);
                    }
                    result = new GunSmithTableResult(raw, tabOverride);
                }
                case GunSmithTableResult.CUSTOM -> {
                    class_1799 itemStack = class_1799.field_49266.fieldOf("item").decode(ops, map).getOrThrow();
                    result = new GunSmithTableResult(itemStack, tabOverride);
                    if (extraTag != null) {
                        result.getResult().method_57368(class_9334.field_49628, class_9279.field_49302, data -> data.method_57451(tag -> {
                            for (String key : extraTag.method_10541()) {
                                class_2520 value = extraTag.method_10580(key);
                                if (value != null) {
                                    tag.method_10566(key, value);
                                }
                            }
                        }));
                    }
                }
                default -> result = new GunSmithTableResult(class_1799.field_8037, TabConfig.TAB_EMPTY);
            }
            return Pair.of(result, input);
        });
    }

    public static final String GUN = "gun";
    public static final String AMMO = "ammo";
    public static final String ATTACHMENT = "attachment";
    public static final String CUSTOM = "custom";

    private class_1799 result = class_1799.field_8037;
    private class_2960 group = null;

    @Nullable
    private RawGunTableResult raw = null;

    public GunSmithTableResult(class_1799 result, @Nullable class_2960 group) {
        this.result = result;
        this.group = group==null ? TabConfig.TAB_EMPTY : group;
    }


    public GunSmithTableResult(@NotNull RawGunTableResult raw) {
        this.raw = raw;
    }

    public GunSmithTableResult(@NotNull RawGunTableResult raw, @Nullable class_2960 group) {
        this.raw = raw;
        this.group = group==null ? TabConfig.TAB_EMPTY : group;
    }

    public void init(class_7225.class_7874 provider) {
        if (raw != null) {
            GunSmithTableResult result = RawGunTableResult.init(provider,raw);
            this.result = result.getResult();
            if (group == null || group.equals(TabConfig.TAB_EMPTY)) {
                this.group = result.getGroup();
            }
            this.raw = null;
        }
    }

    public class_1799 getResult() {
        return result;
    }

    public class_2960 getGroup() {
        return group;
    }
}