package com.tacz.guns.inventory;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.config.sync.SyncConfig;
import com.tacz.guns.crafting.GunSmithTableIngredient;
import com.tacz.guns.crafting.GunSmithTableRecipe;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.ServerMessageCraft;
import com.tacz.guns.resource.filter.RecipeFilter;
import com.tacz.guns.resource.index.CommonBlockIndex;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_8786;
import javax.annotation.Nullable;
import java.util.List;

public class GunSmithTableMenu extends class_1703 {
    public static final class_3917<GunSmithTableMenu> TYPE = new ExtendedScreenHandlerType<>(GunSmithTableMenu::new, class_2960.field_48267);

    private final class_2960 blockId;
    private final RecipeFilter filter;

    public GunSmithTableMenu(int id, class_1661 inventory, @Nullable class_2960 resourceLocation) {
        super(TYPE, id);
        this.blockId = resourceLocation;
        this.filter = TimelessAPI.getCommonBlockIndex(getBlockId()).map(CommonBlockIndex::getFilter).orElse(null);
    }

    @Nullable
    public class_2960 getBlockId() {
        return blockId;
    }

    @Override
    public class_1799 method_7601(class_1657 player, int pIndex) {
        return class_1799.field_8037;
    }

    @Override
    public boolean method_7597(class_1657 player) {
        return player.method_5805();
    }

    @Nullable
    private GunSmithTableRecipe getRecipe(class_2960 recipeId, class_1863 recipeManager) {
        if (!DefaultAssets.DEFAULT_BLOCK_ID.equals(getBlockId()) || SyncConfig.ENABLE_TABLE_FILTER.get()) {
            if (filter != null && !filter.contains(recipeId)) {
                return null;
            }
        }
        class_8786<?> holder = recipeManager.method_8130(recipeId).orElse(null);
        if (holder != null && holder.comp_1933() instanceof GunSmithTableRecipe gunSmithTableRecipe) {
            boolean flag = TimelessAPI.getCommonBlockIndex(getBlockId()).map(blockIndex -> {
                return blockIndex.getData().getTabs().stream().noneMatch(tab -> tab.id().equals(gunSmithTableRecipe.getTab()));
            }).orElse(true);
            if (DefaultAssets.DEFAULT_BLOCK_ID.equals(getBlockId()) && !SyncConfig.ENABLE_TABLE_FILTER.get()) {
                flag = false;
            }
            if (flag) {
                return null;
            }
            return gunSmithTableRecipe;
        }
        return null;
    }

    public void doCraft(class_2960 recipeId, class_1657 player) {
        GunSmithTableRecipe recipe = getRecipe(recipeId, player.method_37908().method_8433());
        if (recipe == null) {
            return;
        }
        player.tacz$getItemHandler(null).ifPresent(handler -> {
            // 是创造模式，就不扣材料
            if (!player.method_7337()) {
                Int2IntArrayMap recordCount = new Int2IntArrayMap();
                List<GunSmithTableIngredient> ingredients = recipe.getInputs();

                for (GunSmithTableIngredient ingredient : ingredients) {
                    int count = 0;
                    for (int slotIndex = 0; slotIndex < handler.getSlots(); slotIndex++) {
                        class_1799 stack = handler.getStackInSlot(slotIndex);
                        int stackCount = stack.method_7947();
                        if (!stack.method_7960() && ingredient.getIngredient().method_8093(stack)) {
                            count = count + stackCount;
                            // 记录扣除的 slot 和数量
                            if (count <= ingredient.getCount()) {
                                // 如果数量不足，全扣
                                recordCount.put(slotIndex, stackCount);
                            } else {
                                //  数量够了，只扣需要的数量
                                int remaining = count - ingredient.getCount();
                                recordCount.put(slotIndex, stackCount - remaining);
                                break;
                            }
                        }
                    }
                    // 数量不够，不执行后续逻辑，合成失败
                    if (count < ingredient.getCount()) {
                        return;
                    }
                }

                // 开始扣材料
                for (int slotIndex : recordCount.keySet()) {
                    handler.extractItem(slotIndex, recordCount.get(slotIndex), false);
                }
            }

            // 给玩家对应的物品
            class_1937 level = player.method_37908();
            if (!level.field_9236) {
                class_1542 itemEntity = new class_1542(level, player.method_23317(), player.method_23318() + 0.5, player.method_23321(), recipe.method_8110(player.method_37908().method_30349()).method_7972());
                itemEntity.method_6982(0);
                level.method_8649(itemEntity);
            }
            // 更新，否则客户端显示不正确
            player.field_7498.method_37420();
            if (player instanceof class_3222 serverPlayer)
                NetworkHandler.sendToClientPlayer(new ServerMessageCraft(this.field_7763), serverPlayer);
        });
    }
}
