package com.tacz.guns.network.message;

import com.tacz.guns.GunMod;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.nbt.AttachmentItemDataAccessor;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import java.util.HashMap;
import java.util.Map;

public class ClientMessageLaserColor implements class_8710 {
    public static final class_8710.class_9154<ClientMessageLaserColor> TYPE = new class_8710.class_9154<>(
            class_2960.method_60655(GunMod.MOD_ID, "client_laser_color")
    );
    public static final class_9139<class_9129, ClientMessageLaserColor> STREAM_CODEC = class_9139.method_56905(
            class_9135.method_56377(HashMap::new, class_9135.method_56375(AttachmentType::fromId, AttachmentType::ordinal), class_9135.field_49675), message -> message.colorMap,
            class_9135.field_48547, message -> message.applyGunColor,
            class_9135.field_49675, message -> message.gunColor,
            class_9135.field_49675, message -> message.gunSlotIndex,
            (colorMap, applyGunColor, gunColor, gunSlotIndex) -> {
                ClientMessageLaserColor message = new ClientMessageLaserColor();
                message.colorMap.putAll(colorMap);
                message.applyGunColor = applyGunColor;
                message.gunColor = gunColor;
                message.gunSlotIndex = gunSlotIndex;
                return message;
            }
    );

    @Override
    public @NotNull class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    private final Map<AttachmentType, Integer> colorMap = new HashMap<>();
    private boolean applyGunColor = false;
    private int gunColor = 0;

    private int gunSlotIndex = -1;

    private ClientMessageLaserColor() {
    }

    public ClientMessageLaserColor(@NotNull class_1799 gun, int gunSlotIndex) {
        if (gun.method_7909() instanceof IGun iGun) {
            for (AttachmentType type : AttachmentType.values()) {
                class_1799 attachment = iGun.getAttachment(class_310.method_1551().field_1687.method_30349(), gun, type);
                if (attachment.method_7909() instanceof IAttachment iAttachment) {
                    if (iAttachment.hasCustomLaserColor(attachment)) {
                        colorMap.put(type, iAttachment.getLaserColor(attachment));
                    }
                }
            }
            if (iGun.hasCustomLaserColor(gun)) {
                this.gunColor = iGun.getLaserColor(gun);
                this.applyGunColor = true;
            }
            this.gunSlotIndex = gunSlotIndex;
        }
    }

    public static void handle(ClientMessageLaserColor message, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_3222 player = context.player();
            if (message.gunSlotIndex == -1) {
                return;
            }
            class_1661 inventory = player.method_31548();
            class_1799 gunItem = inventory.method_5438(message.gunSlotIndex);
            IGun iGun = IGun.getIGunOrNull(gunItem);
            if (iGun != null) {
                for (var entry : message.colorMap.entrySet()) {
                    AttachmentType type = entry.getKey();
                    int color = entry.getValue();
                    class_2487 tag = iGun.getAttachmentTag(gunItem, type);
                    if (tag != null) {
                        AttachmentItemDataAccessor.setLaserColorToTag(tag, color);
                    }
                    iGun.setAttachmentTag(gunItem, type, tag);
                }
                if (message.applyGunColor) {
                    iGun.setLaserColor(gunItem, message.gunColor);
                }
            }
        });
    }

}