package com.tacz.guns.network.message;

import com.tacz.guns.GunMod;
import com.tacz.guns.client.resource.ClientIndexManager;
import com.tacz.guns.resource.network.CommonNetworkCache;
import com.tacz.guns.resource.network.DataType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import java.util.HashMap;
import java.util.Map;

public class ServerMessageSyncGunPack implements class_8710 {
    public static final class_8710.class_9154<ServerMessageSyncGunPack> TYPE = new class_8710.class_9154<>(
            class_2960.method_60655(GunMod.MOD_ID, "server_sync_gun_pack")
    );
    public static final class_9139<class_2540, ServerMessageSyncGunPack> STREAM_CODEC = class_9139.method_56434(
            class_9135.method_56377(HashMap::new, class_9135.method_56368(DataType.CODEC),
                    class_9135.method_56377(HashMap::new, class_2960.field_48267, class_9135.field_48554)),
            ServerMessageSyncGunPack::getCache,
            ServerMessageSyncGunPack::new
    );

    @Override
    public @NotNull class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    private final Map<DataType, Map<class_2960, String>> cache;

    public ServerMessageSyncGunPack(Map<DataType, Map<class_2960, String>> cache) {
        this.cache = cache;
    }

    public static void handle(ServerMessageSyncGunPack message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> doSync(message));
    }


    public Map<DataType, Map<class_2960, String>> getCache() {
        return cache;
    }

    @Environment(EnvType.CLIENT)
    private static void doSync(ServerMessageSyncGunPack message) {
        CommonNetworkCache.INSTANCE.fromNetwork(message.cache);
        // 通知客户端重新构建ClientIndex
        ClientIndexManager.reload();
    }
}