package com.tacz.guns.resource;

import com.tacz.guns.resource.filter.RecipeFilter;
import com.tacz.guns.resource.index.CommonAmmoIndex;
import com.tacz.guns.resource.index.CommonAttachmentIndex;
import com.tacz.guns.resource.index.CommonBlockIndex;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.attachment.AttachmentData;
import com.tacz.guns.resource.pojo.data.block.BlockData;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import org.jetbrains.annotations.Nullable;
import org.luaj.vm2.LuaTable;

import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;

public interface ICommonResourceProvider {
    @Nullable GunData getGunData(class_2960 id);

    @Nullable AttachmentData getAttachmentData(class_2960 attachmentId);

    @Nullable BlockData getBlockData(class_2960 id);

    @Nullable RecipeFilter getRecipeFilter(class_2960 id);

    @Nullable CommonGunIndex getGunIndex(class_2960 gunId);

    @Nullable CommonAmmoIndex getAmmoIndex(class_2960 ammoId);

    @Nullable CommonAttachmentIndex getAttachmentIndex(class_2960 attachmentId);

    @Nullable CommonBlockIndex getBlockIndex(class_2960 blockId);

    @Nullable public LuaTable getScript(class_2960 scriptId);

    Set<Map.Entry<class_2960, CommonGunIndex>> getAllGuns();

    Set<Map.Entry<class_2960, CommonAmmoIndex>> getAllAmmos();

    Set<Map.Entry<class_2960, CommonAttachmentIndex>> getAllAttachments();

    Set<Map.Entry<class_2960, CommonBlockIndex>> getAllBlocks();

    Set<String> getAttachmentTags(class_2960 registryName);

    Set<String> getAllowAttachmentTags(class_2960 registryName);
}
