package com.tacz.guns.resource.manager;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.tacz.guns.GunMod;
import com.tacz.guns.resource.network.DataType;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_7654;

/**
 * 服务端侧数据管理器<br>
 * 该类型的数据管理器用于服务端数据加载并向客户端同步
 * @param <T> 数据类型
 */
public class CommonDataManager<T> extends JsonDataManager<T> implements INetworkCacheReloadListener {
    private final DataType type;
    protected Map<class_2960, String> networkCache;

    public final class_2960 ID;

    public CommonDataManager(DataType type, Class<T> dataClass, Gson pGson, String directory, String marker) {
        super(dataClass, pGson, directory, marker);
        this.type = type;
        this.ID = class_2960.method_60655(GunMod.MOD_ID, this.getType().name().toLowerCase());
    }

    public CommonDataManager(DataType type, Class<T> dataClass, Gson pGson, class_7654 fileToIdConverter, String marker) {
        super(dataClass, pGson, fileToIdConverter, marker);
        this.type = type;
        this.ID = class_2960.method_60655(GunMod.MOD_ID, this.getType().name().toLowerCase());
    }

    @Override
    protected void apply(Map<class_2960, JsonElement> pObject, class_3300 pResourceManager, class_3695 pProfiler) {
        super.apply(pObject, pResourceManager, pProfiler);

        ImmutableMap.Builder<class_2960, String> builder = ImmutableMap.builder();
        pObject.forEach((id, element) -> builder.put(id, element.toString()));
        this.networkCache = builder.build();
    }

    public void clear() {
        this.dataMap.clear();
    }

    public Map<class_2960, String> getNetworkCache() {
        return this.networkCache;
    }

    public DataType getType() {
        return this.type;
    }

    @Override
    public class_2960 getFabricId() {
        return ID;
    }
}
