package com.tacz.guns.resource.modifier.custom;

import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import com.tacz.guns.api.GunProperties;
import com.tacz.guns.api.modifier.CacheValue;
import com.tacz.guns.api.modifier.IAttachmentModifier;
import com.tacz.guns.api.modifier.JsonProperty;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.Ignite;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import java.util.List;

public class IgniteModifier implements IAttachmentModifier<Ignite, Ignite> {
    public static final String ID = GunProperties.IGNITE.name();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public JsonProperty<Ignite> readJson(String json) {
        Data data = CommonAssetsManager.GSON.fromJson(json, Data.class);
        return new IgniteJsonProperty(data.getIgnite());
    }

    @Override
    public CacheValue<Ignite> initCache(class_1799 gunItem, GunData gunData) {
        Ignite ignite = gunData.getBulletData().getIgnite();
        return new CacheValue<>(ignite);
    }

    @Override
    public void eval(List<Ignite> modifiedValues, CacheValue<Ignite> cache) {
        Ignite cacheValue = cache.getValue();
        List<Boolean> igniteEntityValues = Lists.newArrayList();
        igniteEntityValues.add(cacheValue.isIgniteEntity());
        List<Boolean> igniteBlockValues = Lists.newArrayList();
        igniteBlockValues.add(cacheValue.isIgniteBlock());
        modifiedValues.forEach(v -> {
            igniteEntityValues.add(v.isIgniteEntity());
            igniteBlockValues.add(v.isIgniteBlock());
        });
        boolean igniteEntity = AttachmentPropertyManager.eval(igniteEntityValues, false);
        boolean igniteBlock = AttachmentPropertyManager.eval(igniteBlockValues, false);
        cache.setValue(new Ignite(igniteEntity, igniteBlock));
    }

    public static class IgniteJsonProperty extends JsonProperty<Ignite> {
        public IgniteJsonProperty(Ignite value) {
            super(value);
        }

        @Override
        public void initComponents() {
            Ignite value = this.getValue();
            if (value == null) {
                return;
            }
            if (value.isIgniteEntity()) {
                components.add(class_2561.method_43471("tooltip.tacz.attachment.ignite.entity").method_27692(class_124.field_1060));
            }
            if (value.isIgniteBlock()) {
                components.add(class_2561.method_43471("tooltip.tacz.attachment.ignite.block").method_27692(class_124.field_1060));
            }
        }
    }

    private static class Data {
        @SerializedName("ignite")
        private Ignite ignite = new Ignite(false);

        @Nullable
        public Ignite getIgnite() {
            return ignite;
        }
    }
}
