package com.tacz.guns.resource.serialize;

import com.google.gson.*;
import com.mojang.serialization.JsonOps;
import com.tacz.guns.crafting.GunSmithTableIngredient;
import java.lang.reflect.Type;
import net.minecraft.class_1856;
import net.minecraft.class_3518;

public class GunSmithTableIngredientSerializer implements JsonDeserializer<GunSmithTableIngredient> {
    @Override
    public GunSmithTableIngredient deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonObject()) {
            JsonObject jsonObject = json.getAsJsonObject();
            if (!jsonObject.has("item")) {
                throw new JsonSyntaxException("Expected " + jsonObject + " must has a item member");
            }
            class_1856 ingredient = class_1856.field_46095.parse(JsonOps.INSTANCE, jsonObject.get("item")).getOrThrow();
            int count = 1;
            if (jsonObject.has("count")) {
                count = Math.max(class_3518.method_15260(jsonObject, "count"), 1);
            }
            return new GunSmithTableIngredient(ingredient, count);
        } else {
            throw new JsonSyntaxException("Expected " + json + " to be a Pair because it's not an object");
        }
    }
}