package com.tacz.guns.resource.serialize;

import com.google.gson.*;
import com.mojang.serialization.JsonOps;
import com.tacz.guns.GunMod;
import com.tacz.guns.crafting.result.GunSmithTableResult;
import com.tacz.guns.crafting.result.RawGunTableResult;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.pojo.data.block.TabConfig;
import com.tacz.guns.resource.pojo.data.recipe.GunResult;
import java.lang.reflect.Type;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3518;


public class GunSmithTableResultSerializer implements JsonDeserializer<GunSmithTableResult> {

    @Override
    public GunSmithTableResult deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonObject()) {
            JsonObject jsonObject = json.getAsJsonObject();
            String typeName = class_3518.method_15265(jsonObject, "type");
            int count = 1;
            class_2487 extraTag = null;
            class_2960 tabOverride = null;
            if (jsonObject.has("count")) {
                count = Math.max(class_3518.method_15260(jsonObject, "count"), 1);
            }
            if (jsonObject.has("nbt")) {
                extraTag = class_2487.field_25128.parse(JsonOps.INSTANCE, jsonObject.get("nbt")).getOrThrow();
            }
            if (jsonObject.has("group")) {
                String raw = class_3518.method_15265(jsonObject, "group");
                if (!raw.contains(":")) {
                    raw = GunMod.MOD_ID + ":" + raw;
                }
                tabOverride = class_2960.method_12829(raw);
            }

            GunSmithTableResult result;
            switch (typeName) {
                case GunSmithTableResult.GUN, GunSmithTableResult.AMMO, GunSmithTableResult.ATTACHMENT -> {
                    RawGunTableResult raw = new RawGunTableResult(typeName, getId(jsonObject), count);
                    if (extraTag != null) {
                        raw.setNbt(extraTag);
                    }
                    if (typeName.equals(GunSmithTableResult.GUN)) {
                        GunResult gunResult = CommonAssetsManager.GSON.fromJson(jsonObject, GunResult.class);
                        if (gunResult != null) {
                            raw.setExtraData(gunResult);
                        }
                    }

                    result = new GunSmithTableResult(raw, tabOverride);
                }
                case GunSmithTableResult.CUSTOM -> {
                    JsonObject resultObject = class_3518.method_15296(jsonObject, "item");
                    class_1799 itemStack = class_1799.field_24671.parse(JsonOps.INSTANCE, resultObject).getOrThrow();
                    result = new GunSmithTableResult(itemStack, tabOverride);
                }
                default -> {
                    return new GunSmithTableResult(class_1799.field_8037, TabConfig.TAB_EMPTY);
                }
            }
            return result;
        }
        return new GunSmithTableResult(class_1799.field_8037, TabConfig.TAB_EMPTY);
    }

    private class_2960 getId(JsonObject jsonObject) {
        return class_2960.method_60654(class_3518.method_15265(jsonObject, "id"));
    }
}