package com.tacz.guns.resource.serialize;

import com.google.gson.*;
import com.tacz.guns.resource.pojo.data.gun.Ignite;
import java.lang.reflect.Type;
import net.minecraft.class_3518;

public class IgniteSerializer implements JsonDeserializer<Ignite> {
    @Override
    public Ignite deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (class_3518.method_34921(json)) {
            boolean ignite = class_3518.method_15268(json, "ignite");
            return new Ignite(ignite);
        } else if (json.isJsonObject()) {
            JsonObject jsonObject = json.getAsJsonObject();
            boolean igniteEntity = class_3518.method_15258(jsonObject, "entity", false);
            boolean igniteBlock = class_3518.method_15258(jsonObject, "block", false);
            return new Ignite(igniteEntity, igniteBlock);
        }
        throw new JsonSyntaxException("Expected " + json + " to be a Pair because it's not an array");
    }
}
