/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gameplay;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.gameplay.LocalPlayerDataHolder;
import com.tacz.guns.network.message.ClientMessagePlayerAim;
import com.tacz.guns.resource.modifier.custom.AdsModifier;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import net.minecraft.class_8710;

public class LocalPlayerAim {
    private final LocalPlayerDataHolder data;
    private final class_746 player;

    public LocalPlayerAim(LocalPlayerDataHolder data, class_746 player) {
        this.data = data;
        this.player = player;
    }

    public void aim(boolean isAim) {
        class_1799 mainHandItem = this.player.method_6047();
        class_1792 class_17922 = mainHandItem.method_7909();
        if (!(class_17922 instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)class_17922;
        class_2960 gunId = iGun.getGunId(mainHandItem);
        TimelessAPI.getClientGunIndex(gunId).ifPresent(gunIndex -> {
            this.data.clientIsAiming = isAim;
            ClientPlayNetworking.send((class_8710)new ClientMessagePlayerAim(isAim));
        });
    }

    public float getClientAimingProgress(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)LocalPlayerDataHolder.oldAimingProgress, (float)this.data.clientAimingProgress);
    }

    public boolean isAim() {
        return this.data.clientIsAiming;
    }

    public void tickAimingProgress() {
        class_1799 mainHandItem = this.player.method_6047();
        class_1792 class_17922 = mainHandItem.method_7909();
        if (!(class_17922 instanceof IGun)) {
            this.data.clientAimingProgress = 0.0f;
            LocalPlayerDataHolder.oldAimingProgress = 0.0f;
            return;
        }
        IGun iGun = (IGun)class_17922;
        if (System.currentTimeMillis() - this.data.clientDrawTimestamp < 0L) {
            this.data.clientIsAiming = false;
        }
        class_2960 gunId = iGun.getGunId(mainHandItem);
        TimelessAPI.getCommonGunIndex(gunId).ifPresentOrElse(index -> {
            float alphaProgress = this.getAlphaProgress(index.getGunData());
            this.aimProgressCalculate(alphaProgress);
        }, () -> {
            this.data.clientAimingProgress = 0.0f;
            LocalPlayerDataHolder.oldAimingProgress = 0.0f;
        });
    }

    private void aimProgressCalculate(float alphaProgress) {
        LocalPlayerDataHolder.oldAimingProgress = this.data.clientAimingProgress;
        if (this.data.clientIsAiming) {
            this.data.clientAimingProgress += alphaProgress;
            if (this.data.clientAimingProgress > 1.0f) {
                this.data.clientAimingProgress = 1.0f;
            }
        } else {
            this.data.clientAimingProgress -= alphaProgress;
            if (this.data.clientAimingProgress < 0.0f) {
                this.data.clientAimingProgress = 0.0f;
            }
        }
        this.data.clientAimingTimestamp = System.currentTimeMillis();
    }

    private float getAlphaProgress(GunData gunData) {
        float aimTime = gunData.getAimTime();
        IGunOperator operator = IGunOperator.fromLivingEntity((class_1309)this.player);
        if (operator.getCacheProperty() != null) {
            aimTime = ((Float)operator.getCacheProperty().getCache(AdsModifier.ID)).floatValue();
        }
        aimTime = Math.max(0.0f, aimTime);
        return (float)(System.currentTimeMillis() - this.data.clientAimingTimestamp + 1L) / (aimTime * 1000.0f);
    }
}

