package cn.sh1rocu.tacz.mixin.common;

import cn.sh1rocu.tacz.api.event.EntityJoinLevelEvent;
import net.minecraft.class_1297;
import net.minecraft.class_5568;
import net.minecraft.class_5579;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_5579.class)
public class PersistentEntitySectionManagerMixin<T extends class_5568> {
    @Inject(method = "addEntity", at = @At("HEAD"), cancellable = true)
    private void tlm$entityJoinLevelEvent(T entityAccess, boolean loadedFromDisk, CallbackInfoReturnable<Boolean> cir) {
        if (entityAccess instanceof class_1297 entity) {
            EntityJoinLevelEvent event = new EntityJoinLevelEvent(entity, entity.method_37908(), loadedFromDisk);
            EntityJoinLevelEvent.CALLBACK.invoker().post(event);
            if (event.isCanceled())
                cir.setReturnValue(false);
        }
    }
}