package com.tacz.guns.api.item.builder;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.init.ModItems;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public final class AmmoItemBuilder {
    private int count = 1;
    private class_2960 ammoId = DefaultAssets.DEFAULT_AMMO_ID;

    private AmmoItemBuilder() {
    }

    public static AmmoItemBuilder create() {
        return new AmmoItemBuilder();
    }

    public AmmoItemBuilder setCount(int count) {
        this.count = Math.max(count, 1);
        return this;
    }

    public AmmoItemBuilder setId(class_2960 id) {
        this.ammoId = id;
        return this;
    }

    public class_1799 build() {
        class_1799 ammo = new class_1799(ModItems.AMMO, this.count);
        if (ammo.method_7909() instanceof IAmmo iAmmo) {
            iAmmo.setAmmoId(ammo, this.ammoId);
        }
        return ammo;
    }
}
