package com.tacz.guns.client.renderer.item;

import com.google.common.base.Suppliers;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.client.model.BedrockAmmoModel;
import com.tacz.guns.client.model.SlotModel;
import com.tacz.guns.client.model.bedrock.BedrockPart;
import com.tacz.guns.client.resource.pojo.TransformScale;
import org.joml.Vector3f;

import javax.annotation.Nonnull;
import net.minecraft.class_1047;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_756;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_824;
import java.util.List;
import java.util.function.Supplier;

import static net.minecraft.class_811.field_4317;


public class AmmoItemRenderer extends class_756 {
    private static final SlotModel SLOT_AMMO_MODEL = new SlotModel();

    public static final Supplier<AmmoItemRenderer> INSTANCE = Suppliers.memoize(() -> {
        class_310 client = class_310.method_1551();
        return new AmmoItemRenderer(client.method_31975(), client.method_31974());
    });

    public AmmoItemRenderer(class_824 pBlockEntityRenderDispatcher, class_5599 pEntityModelSet) {
        super(pBlockEntityRenderDispatcher, pEntityModelSet);
    }

    private static void applyPositioningNodeTransform(List<BedrockPart> nodePath, class_4587 poseStack, Vector3f scale) {
        if (nodePath == null) {
            return;
        }
        if (scale == null) {
            scale = new Vector3f(1, 1, 1);
        }
        // 应用定位组的反向位移、旋转，使定位组的位置就是渲染中心
        poseStack.method_22904(0, 1.5, 0);
        for (int i = nodePath.size() - 1; i >= 0; i--) {
            BedrockPart t = nodePath.get(i);
            poseStack.method_22907(class_7833.field_40713.rotation(t.xRot));
            poseStack.method_22907(class_7833.field_40715.rotation(t.yRot));
            poseStack.method_22907(class_7833.field_40717.rotation(t.zRot));
            if (t.getParent() != null) {
                poseStack.method_46416(-t.x * scale.x() / 16.0F, -t.y * scale.y() / 16.0F, -t.z * scale.z() / 16.0F);
            } else {
                poseStack.method_46416(-t.x * scale.x() / 16.0F, (1.5F - t.y / 16.0F) * scale.y(), -t.z * scale.z() / 16.0F);
            }
        }
        poseStack.method_22904(0, -1.5, 0);
    }

    @Override
    public void method_3166(@Nonnull class_1799 stack, @Nonnull class_811 transformType, @Nonnull class_4587 poseStack, @Nonnull class_4597 pBuffer, int pPackedLight, int pPackedOverlay) {
        if (!(stack.method_7909() instanceof IAmmo iAmmo)) {
            return;
        }
        class_2960 ammoId = iAmmo.getAmmoId(stack);
        poseStack.method_22903();
        TimelessAPI.getClientAmmoIndex(ammoId).ifPresentOrElse(ammoIndex -> {
            // 先获取 3D 模型，如果为空，统一使用 GUI 渲染
            BedrockAmmoModel ammoModel = ammoIndex.getAmmoModel();
            class_2960 modelTexture = ammoIndex.getModelTextureLocation();
            // GUI 特殊渲染
            if (transformType == field_4317 || ammoModel == null || modelTexture == null) {
                poseStack.method_22904(0.5, 1.5, 0.5);
                poseStack.method_22907(class_7833.field_40717.rotationDegrees(180));
                class_4588 buffer = pBuffer.getBuffer(class_1921.method_23580(ammoIndex.getSlotTextureLocation()));
                SLOT_AMMO_MODEL.method_2828(poseStack, buffer, pPackedLight, pPackedOverlay, 1.0F, 1.0F, 1.0F, 1.0F);
                return;
            }
            // 剩下的渲染
            // 移动到模型原点
            poseStack.method_22904(0.5, 2, 0.5);
            // 反转模型
            poseStack.method_22905(-1, -1, 1);
            // 应用定位组的变换（位移和旋转，不包括缩放）
            applyPositioningTransform(transformType, ammoIndex.getTransform().getScale(), ammoModel, poseStack);
            // 应用 display 数据中的缩放
            applyScaleTransform(transformType, ammoIndex.getTransform().getScale(), poseStack);
            // 渲染子弹盒模型
            class_1921 renderType = class_1921.method_23576(modelTexture);
            ammoModel.render(poseStack, transformType, renderType, pPackedLight, pPackedOverlay);
        }, () -> {
            // 没有这个 ammoID，渲染个错误材质提醒别人
            poseStack.method_22904(0.5, 1.5, 0.5);
            poseStack.method_22907(class_7833.field_40717.rotationDegrees(180));
            class_4588 buffer = pBuffer.getBuffer(class_1921.method_23580(class_1047.method_4539()));
            SLOT_AMMO_MODEL.method_2828(poseStack, buffer, pPackedLight, pPackedOverlay, 1.0F, 1.0F, 1.0F, 1.0F);
        });
        poseStack.method_22909();
    }

    private void applyPositioningTransform(class_811 transformType, TransformScale scale, BedrockAmmoModel model, class_4587 poseStack) {
        switch (transformType) {
            case field_4319 -> applyPositioningNodeTransform(model.getFixedOriginPath(), poseStack, scale.getFixed());
            case field_4318 -> applyPositioningNodeTransform(model.getGroundOriginPath(), poseStack, scale.getGround());
            case field_4320, field_4323 ->
                    applyPositioningNodeTransform(model.getThirdPersonHandOriginPath(), poseStack, scale.getThirdPerson());
        }
    }

    private void applyScaleTransform(class_811 transformType, TransformScale scale, class_4587 poseStack) {
        if (scale == null) {
            return;
        }
        Vector3f vector3f = null;
        switch (transformType) {
            case field_4319 -> vector3f = scale.getFixed();
            case field_4318 -> vector3f = scale.getGround();
            case field_4320, field_4323 -> vector3f = scale.getThirdPerson();
        }
        if (vector3f != null) {
            poseStack.method_22904(0, 1.5, 0);
            poseStack.method_22905(vector3f.x(), vector3f.y(), vector3f.z());
            poseStack.method_22904(0, -1.5, 0);
        }
    }
}
