package com.tacz.guns.client.renderer.item;

import com.google.common.base.Suppliers;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.client.model.BedrockAttachmentModel;
import com.tacz.guns.client.model.SlotModel;
import com.tacz.guns.client.resource.index.ClientAttachmentIndex;
import com.tacz.guns.util.RenderDistance;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

import javax.annotation.Nonnull;
import net.minecraft.class_1047;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_756;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_824;
import java.util.function.Supplier;

public class AttachmentItemRenderer extends class_756 {
    public static final SlotModel SLOT_ATTACHMENT_MODEL = new SlotModel();

    public static final Supplier<AttachmentItemRenderer> INSTANCE = Suppliers.memoize(() -> {
        class_310 client = class_310.method_1551();
        return new AttachmentItemRenderer(client.method_31975(), client.method_31974());
    });

    public AttachmentItemRenderer(class_824 pBlockEntityRenderDispatcher, class_5599 pEntityModelSet) {
        super(pBlockEntityRenderDispatcher, pEntityModelSet);
    }

    @Override
    public void method_3166(@Nonnull class_1799 stack, @Nonnull class_811 transformType, @Nonnull class_4587 poseStack, @Nonnull class_4597 pBuffer, int pPackedLight, int pPackedOverlay) {
        if (stack.method_7909() instanceof IAttachment iAttachment) {
            class_2960 attachmentId = iAttachment.getAttachmentId(stack);
            poseStack.method_22903();
            TimelessAPI.getClientAttachmentIndex(attachmentId).ifPresentOrElse(attachmentIndex -> {
                // GUI 特殊渲染
                if (transformType == class_811.field_4317) {
                    poseStack.method_22904(0.5, 1.5, 0.5);
                    poseStack.method_22907(class_7833.field_40717.rotationDegrees(180));
                    class_4588 buffer = pBuffer.getBuffer(class_1921.method_23580(attachmentIndex.getSlotTexture()));
                    SLOT_ATTACHMENT_MODEL.method_2828(poseStack, buffer, pPackedLight, pPackedOverlay, 1.0F, 1.0F, 1.0F, 1.0F);
                    return;
                }
                poseStack.method_22904(0.5, 2, 0.5);
                // 反转模型
                poseStack.method_22905(-1, -1, 1);
                if (transformType == class_811.field_4319) {
                    poseStack.method_22907(class_7833.field_40715.rotationDegrees(90f));
                }
                this.renderDefaultAttachment(transformType, poseStack, pBuffer, pPackedLight, pPackedOverlay, attachmentIndex);
            }, () -> {
                // 没有这个 attachmentId，渲染黑紫材质以提醒
                poseStack.method_22904(0.5, 1.5, 0.5);
                poseStack.method_22907(class_7833.field_40717.rotationDegrees(180));
                class_4588 buffer = pBuffer.getBuffer(class_1921.method_23580(class_1047.method_4539()));
                SLOT_ATTACHMENT_MODEL.method_2828(poseStack, buffer, pPackedLight, pPackedOverlay, 1.0F, 1.0F, 1.0F, 1.0F);
            });
            poseStack.method_22909();
        }
    }

    private void renderDefaultAttachment(@NotNull class_811 transformType, @NotNull class_4587 poseStack, @NotNull class_4597 pBuffer, int pPackedLight, int pPackedOverlay, ClientAttachmentIndex attachmentIndex) {
        BedrockAttachmentModel model = attachmentIndex.getAttachmentModel();
        class_2960 texture = attachmentIndex.getModelTexture();
        // 有模型？正常渲染
        if (model != null && texture != null) {
            // 调用低模
            Pair<BedrockAttachmentModel, class_2960> lodModel = attachmentIndex.getLodModel();
            // 有低模、在高模渲染范围外、不是第一人称
            if (lodModel != null && !RenderDistance.inRenderHighPolyModelDistance(poseStack) && !transformType.method_29998()) {
                model = lodModel.getLeft();
                texture = lodModel.getRight();
            }
            class_1921 renderType = class_1921.method_23576(texture);
            model.render(null, null, poseStack, transformType, renderType, pPackedLight, pPackedOverlay);
        }
        // 否则，以 GUI 形式渲染
        else {
            poseStack.method_22904(0, 0.5, 0);
            // 展示框里显示正常
            if (transformType == class_811.field_4319) {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(90));
            }
            class_4588 buffer = pBuffer.getBuffer(class_1921.method_23580(attachmentIndex.getSlotTexture()));
            SLOT_ATTACHMENT_MODEL.method_2828(poseStack, buffer, pPackedLight, pPackedOverlay, 1.0F, 1.0F, 1.0F, 1.0F);
        }
    }
}
