package com.tacz.guns.client.renderer.item;

import cn.sh1rocu.tacz.api.event.ViewportEvent;
import com.google.common.base.Suppliers;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.animation.statemachine.LuaAnimationStateMachine;
import com.tacz.guns.api.client.event.BeforeRenderHandEvent;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.client.other.KeepingItemRenderer;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.animation.screen.RefitTransform;
import com.tacz.guns.client.animation.statemachine.GunAnimationConstant;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateContext;
import com.tacz.guns.client.event.CameraSetupEvent;
import com.tacz.guns.client.event.FirstPersonRenderGunEvent;
import com.tacz.guns.client.model.BedrockGunModel;
import com.tacz.guns.client.model.SlotModel;
import com.tacz.guns.client.model.bedrock.BedrockPart;
import com.tacz.guns.client.model.functional.MuzzleFlashRender;
import com.tacz.guns.client.model.functional.ShellRender;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.pojo.TransformScale;
import com.tacz.guns.util.RenderDistance;
import com.tacz.guns.util.math.MathUtil;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1047;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

import static net.minecraft.class_811.*;

/**
 * 负责主要的枪械动画模型渲染。额外的效果见 {@link FirstPersonRenderGunEvent}
 */
public class GunItemRendererWrapper extends AnimateGeoItemRenderer<BedrockGunModel, GunAnimationStateContext> {
    private static final SlotModel SLOT_GUN_MODEL = new SlotModel();
    private static BedrockGunModel lastModel = null;
    public static final Vector3f muzzleRenderOffset = new Vector3f();

    public static final Supplier<GunItemRendererWrapper> INSTANCE = Suppliers.memoize(GunItemRendererWrapper::new);

    public GunItemRendererWrapper() {
        super();
    }

    @Override
    public GunAnimationStateContext initContext(class_1799 stack, class_1657 player, float partialTick) {
        GunAnimationStateContext context = new GunAnimationStateContext();
        this.updateContext(context, stack, player, partialTick);
        return context;
    }

    @Override
    public void updateContext(GunAnimationStateContext context, class_1799 stack, class_1657 player, float partialTick) {
        context.setPartialTicks(partialTick);
        context.setCurrentGunItem(stack);
    }

    @Override
    public void tryInit(class_1799 stack, class_1657 player, float partialTick) {
        super.tryInit(stack, player, partialTick);
    }

    @Override
    public void tryExit(class_1799 stack, long putAwayTime) {
        var stateMachine = getStateMachine(stack);
        if (stateMachine == null) {
            return;
        }
        stateMachine.processContextIfExist(context -> {
            context.setPutAwayTime(putAwayTime / 1000F);
            context.setCurrentGunItem(stack);
        });
        if (stateMachine.isInitialized()) {
            stateMachine.trigger(GunAnimationConstant.INPUT_PUT_AWAY);
            KeepingItemRenderer.getRenderer().keep(stack, putAwayTime);
            stateMachine.exit();
            stateMachine.setExitingTime(putAwayTime + 50);
        }
    }

    @Override
    public long getPutAwayTime(class_1799 stack) {
        if (stack.method_7909() instanceof IGun iGun) {
            return TimelessAPI.getCommonGunIndex(iGun.getGunId(stack))
                    .map(index -> (long) (index.getGunData().getPutAwayTime() * 1000L))
                    .orElse(0L);
        }
        return 0;
    }

    @Nullable
    @Override
    public LuaAnimationStateMachine<GunAnimationStateContext> getStateMachine(class_1799 stack) {
        return TimelessAPI.getGunDisplay(stack).map(GunDisplayInstance::getAnimationStateMachine).orElse(null);
    }

    @Override
    public BedrockGunModel getModel(class_1799 stack) {
        return TimelessAPI.getGunDisplay(stack).map(GunDisplayInstance::getGunModel).orElse(null);
    }

    @Override
    public class_2960 getTextureLocation(class_1799 stack) {
        return TimelessAPI.getGunDisplay(stack).map(GunDisplayInstance::getModelTexture).orElse(null);
    }

    @Override
    public void applyLevelCameraAnimation(ViewportEvent.ComputeCameraAngles event, class_1799 stack, class_746 player) {
        if (!(stack.method_7909() instanceof IGun iGun)) {
            return;
        }
        Optional.ofNullable(getModel(stack)).ifPresent(model -> {
            if (lastModel != model) {
                // 切换枪械模型的时候清理一下摄像机动画数据，以避免上一次播放到一半的摄像机动画影响观感。
                model.cleanCameraAnimationTransform();
                lastModel = model;
            }
            IClientPlayerGunOperator clientPlayerGunOperator = IClientPlayerGunOperator.fromLocalPlayer(player);
            float partialTicks = class_310.method_1551().method_1488();
            float aimingProgress = clientPlayerGunOperator.getClientAimingProgress(partialTicks);
            float zoom = iGun.getAimingZoom(stack);
            float multiplier = 1 - aimingProgress + aimingProgress / (float) Math.sqrt(zoom);
            this.applyLevelCameraAnimation(event, stack, multiplier);
        });
    }

    @Override
    public void applyItemInHandCameraAnimation(BeforeRenderHandEvent event, class_1799 stack, class_746 player) {
        if (!(stack.method_7909() instanceof IGun iGun)) {
            return;
        }
        Optional.ofNullable(getModel(stack)).ifPresent(model -> {
            class_4587 poseStack = event.getPoseStack();
            IClientPlayerGunOperator clientPlayerGunOperator = IClientPlayerGunOperator.fromLocalPlayer(player);
            float partialTicks = class_310.method_1551().method_1488();
            float aimingProgress = clientPlayerGunOperator.getClientAimingProgress(partialTicks);
            float zoom = iGun.getAimingZoom(stack);
            float multiplier = 1 - aimingProgress + aimingProgress / (float) Math.sqrt(zoom);
            Quaternionf quaternion = MathUtil.multiplyQuaternion(model.getCameraAnimationObject().rotationQuaternion, multiplier);
            poseStack.method_22907(quaternion);
            // 截至目前，摄像机动画数据已消费完毕。是否有更好的清理动画数据的方法？
            model.cleanCameraAnimationTransform();
        });
    }

    @Override
    public void renderFirstPerson(class_746 player, class_1799 stack, class_811 ctx, class_4587 poseStack, class_4597 bufferSource,
                                  int light, float partialTick) {
        if (!(stack.method_7909() instanceof IGun)) {
            return;
        }

        TimelessAPI.getGunDisplay(stack).ifPresent(display -> {
            BedrockGunModel gunModel = display.getGunModel();
            var animationStateMachine = display.getAnimationStateMachine();
            if (gunModel == null) {
                return;
            }

            // 在渲染之前，先更新动画，让动画数据写入模型
            animationStateMachine.processContextIfExist(context -> {
                updateContext(context, stack, player, partialTick);
            });
            animationStateMachine.update();

            poseStack.method_22903();
            // 逆转原版施加在手上的延滞效果，改为写入模型动画数据中
            float xRotOffset = class_3532.method_16439(partialTick, player.field_3914, player.field_3916);
            float yRotOffset = class_3532.method_16439(partialTick, player.field_3931, player.field_3932);
            float xRot = player.method_5695(partialTick) - xRotOffset;
            float yRot = player.method_5705(partialTick) - yRotOffset;
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(xRot * -0.1F));
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(yRot * -0.1F));
            BedrockPart rootNode = gunModel.getRootNode();
            if (rootNode != null) {
                xRot = (float) Math.tanh(xRot / 25) * 25;
                yRot = (float) Math.tanh(yRot / 25) * 25;
                rootNode.offsetX += yRot * 0.1F / 16F / 3F;
                rootNode.offsetY += -xRot * 0.1F / 16F / 3F;
                rootNode.additionalQuaternion.mul(class_7833.field_40714.rotationDegrees(xRot * 0.05F));
                rootNode.additionalQuaternion.mul(class_7833.field_40716.rotationDegrees(yRot * 0.05F));
            }
            // 从渲染原点 (0, 24, 0) 移动到模型原点 (0, 0, 0)
            poseStack.method_46416(0, 1.5f, 0);
            // 基岩版模型是上下颠倒的，需要翻转过来。
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(180f));
            // 应用持枪姿态变换，如第一人称摄像机定位
            FirstPersonRenderGunEvent.applyFirstPersonGunTransform(player, stack, poseStack, gunModel, partialTick);

            // 开启第一人称弹壳和火焰渲染
            MuzzleFlashRender.isSelf = true;
            ShellRender.isSelf = true;
            // 如果正在打开改装界面，则取消手臂渲染
            boolean renderHand = gunModel.getRenderHand();
            if (RefitTransform.getOpeningProgress() != 0) {
                gunModel.setRenderHand(false);
            }
            // 调用枪械模型渲染
            class_1921 renderType = class_1921.method_23576(display.getModelTexture());
            gunModel.render(poseStack, stack, ctx, renderType, light, class_4608.field_21444);
            // 缓存枪口位置，为第一人称曳光弹渲染作准备
            cacheMuzzlePosition(poseStack, gunModel);
            // 恢复手臂渲染
            gunModel.setRenderHand(renderHand);
            // 渲染完成后，将动画数据从模型中清除，不对其他视角下的模型渲染产生影响
            poseStack.method_22909();
            gunModel.cleanAnimationTransform();
            // 关闭第一人称弹壳和火焰渲染
            MuzzleFlashRender.isSelf = false;
            ShellRender.isSelf = false;
        });
    }

    private static void cacheMuzzlePosition(class_4587 poseStack, BedrockGunModel gunModel) {
        if (gunModel.getMuzzleFlashPosPath() != null) {
            // 计算出枪口相对于摄像机中心的坐标
            poseStack.method_22903();
            for (BedrockPart bedrockPart : gunModel.getMuzzleFlashPosPath()) {
                bedrockPart.translateAndRotateAndScale(poseStack);
            }
            Matrix4f pose = poseStack.method_23760().method_23761();
            double itemRenderFov = CameraSetupEvent.ITEM_MODEL_FOV_DYNAMICS.get();
            double levelRenderFov = CameraSetupEvent.WORLD_FOV_DYNAMICS.get();
            poseStack.method_22909();
            // 缓存转换后的偏移坐标
            muzzleRenderOffset.set(
                    pose.m30(),
                    pose.m31(),
                    pose.m32() * Math.tan(itemRenderFov / 2 * Math.PI / 180) / Math.tan(levelRenderFov / 2 * Math.PI / 180)
            );
        }
    }


    @Override
    public void method_3166(@Nonnull class_1799 stack, @Nonnull class_811 transformType, @Nonnull class_4587 poseStack, @Nonnull class_4597 pBuffer,
                             int pPackedLight, int pPackedOverlay) {
        if (!(stack.method_7909() instanceof IGun)) {
            return;
        }
        poseStack.method_22903();
        TimelessAPI.getGunDisplay(stack).ifPresentOrElse(gunIndex -> {
            // 第一人称就不渲染了，交给别的地方
            if (transformType == field_4321 || transformType == field_4322) {
                return;
            }
            // 第三人称副手也不渲染了
            if (transformType == field_4323) {
                return;
            }
            // GUI 特殊渲染
            if (transformType == field_4317) {
                poseStack.method_22904(0.5, 1.5, 0.5);
                poseStack.method_22907(class_7833.field_40717.rotationDegrees(180));
                class_4588 buffer = pBuffer.getBuffer(class_1921.method_23580(gunIndex.getSlotTexture()));
                SLOT_GUN_MODEL.method_2828(poseStack, buffer, pPackedLight, pPackedOverlay, 1.0F, 1.0F, 1.0F, 1.0F);
                return;
            }
            // 剩下的渲染
            BedrockGunModel gunModel;
            class_2960 gunTexture;
            Pair<BedrockGunModel, class_2960> lodModel = gunIndex.getLodModel();
            if (lodModel == null || RenderDistance.inRenderHighPolyModelDistance(poseStack)) {
                gunModel = gunIndex.getGunModel();
                gunTexture = gunIndex.getModelTexture();
            } else {
                gunModel = lodModel.getLeft();
                gunTexture = lodModel.getRight();
            }
            // 移动到模型原点
            poseStack.method_22904(0.5, 2, 0.5);
            // 反转模型
            poseStack.method_22905(-1, -1, 1);
            // 应用定位组的变换（位移和旋转，不包括缩放）
            applyPositioningTransform(transformType, gunIndex.getTransform().getScale(), gunModel, poseStack);
            // 应用 display 数据中的缩放
            applyScaleTransform(transformType, gunIndex.getTransform().getScale(), poseStack);
            // 渲染枪械模型
            class_1921 renderType = class_1921.method_23576(gunTexture);
            gunModel.render(poseStack, stack, transformType, renderType, pPackedLight, pPackedOverlay);
        }, () -> {
            // 没有这个 gunID，渲染个错误材质提醒别人
            poseStack.method_22904(0.5, 1.5, 0.5);
            poseStack.method_22907(class_7833.field_40717.rotationDegrees(180));
            class_4588 buffer = pBuffer.getBuffer(class_1921.method_23580(class_1047.method_4539()));
            SLOT_GUN_MODEL.method_2828(poseStack, buffer, pPackedLight, pPackedOverlay, 1.0F, 1.0F, 1.0F, 1.0F);
        });
        poseStack.method_22909();
    }

    private static void applyPositioningTransform(class_811 transformType, TransformScale scale, BedrockGunModel model,
                                                  class_4587 poseStack) {
        switch (transformType) {
            case field_4319 -> applyPositioningNodeTransform(model.getFixedOriginPath(), poseStack, scale.getFixed());
            case field_4318 -> applyPositioningNodeTransform(model.getGroundOriginPath(), poseStack, scale.getGround());
            case field_4320, field_4323 ->
                    applyPositioningNodeTransform(model.getThirdPersonHandOriginPath(), poseStack, scale.getThirdPerson());
        }
    }

    private static void applyScaleTransform(class_811 transformType, TransformScale scale, class_4587 poseStack) {
        if (scale == null) {
            return;
        }
        Vector3f vector3f = null;
        switch (transformType) {
            case field_4319 -> vector3f = scale.getFixed();
            case field_4318 -> vector3f = scale.getGround();
            case field_4320, field_4323 -> vector3f = scale.getThirdPerson();
        }
        if (vector3f != null) {
            poseStack.method_22904(0, 1.5, 0);
            poseStack.method_22905(vector3f.x(), vector3f.y(), vector3f.z());
            poseStack.method_22904(0, -1.5, 0);
        }
    }

    private static void applyPositioningNodeTransform(List<BedrockPart> nodePath, class_4587 poseStack, Vector3f scale) {
        if (nodePath == null) {
            return;
        }
        if (scale == null) {
            scale = new Vector3f(1, 1, 1);
        }
        // 应用定位组的反向位移、旋转，使定位组的位置就是渲染中心
        poseStack.method_22904(0, 1.5, 0);
        for (int i = nodePath.size() - 1; i >= 0; i--) {
            BedrockPart t = nodePath.get(i);
            poseStack.method_22907(class_7833.field_40713.rotation(t.xRot));
            poseStack.method_22907(class_7833.field_40715.rotation(t.yRot));
            poseStack.method_22907(class_7833.field_40717.rotation(t.zRot));
            if (t.getParent() != null) {
                poseStack.method_46416(-t.x * scale.x() / 16.0F, -t.y * scale.y() / 16.0F, -t.z * scale.z() / 16.0F);
            } else {
                poseStack.method_46416(-t.x * scale.x() / 16.0F, (1.5F - t.y / 16.0F) * scale.y(), -t.z * scale.z() / 16.0F);
            }
        }
        poseStack.method_22904(0, -1.5, 0);
    }
}
