package com.tacz.guns.client.renderer.item;

import com.google.common.base.Suppliers;
import com.tacz.guns.client.model.SlotModel;
import com.tacz.guns.client.model.bedrock.BedrockModel;
import com.tacz.guns.client.renderer.block.GunSmithTableRenderer;
import javax.annotation.Nonnull;
import net.minecraft.class_1047;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_756;
import net.minecraft.class_7833;
import net.minecraft.class_804;
import net.minecraft.class_809;
import net.minecraft.class_811;
import net.minecraft.class_824;
import java.util.function.Supplier;

public class GunSmithTableItemRenderer extends class_756 {
    private static final SlotModel SLOT_BLOCK_MODEL = new SlotModel();

    public static final Supplier<GunSmithTableItemRenderer> INSTANCE = Suppliers.memoize(() -> {
        class_310 client = class_310.method_1551();
        return new GunSmithTableItemRenderer(client.method_31975(), client.method_31974());
    });

    public GunSmithTableItemRenderer(class_824 dispatcher, class_5599 modelSet) {
        super(dispatcher, modelSet);
    }

    @Override
    public void method_3166(@Nonnull class_1799 stack, @Nonnull class_811 transformType, @Nonnull class_4587 poseStack, @Nonnull class_4597 pBuffer, int pPackedLight, int pPackedOverlay) {
        GunSmithTableRenderer.getIndex(stack).ifPresentOrElse(index -> {
            BedrockModel model = index.getModel();
            class_2960 texture = index.getTexture();
            if (model == null) {
                return;
            }
            poseStack.method_22903();

            class_809 transforms = index.getTransforms();
            if (transforms != null) {
                poseStack.method_46416(0.5F, 0.5F, 0.5F);
                class_804 transform = transforms.method_3503(transformType);
                transform.method_23075(false, poseStack);
                poseStack.method_46416(-0.5F, -0.5F, -0.5F);
            }

            poseStack.method_22904(0.5, 1.5, 0.5);
            poseStack.method_22907(class_7833.field_40717.rotationDegrees(180));
            class_1921 renderType = class_1921.method_23580(texture);
            model.render(poseStack, transformType, renderType, pPackedLight, pPackedOverlay);
            poseStack.method_22909();
        }, () -> {
            poseStack.method_22904(0.5, 1.5, 0.5);
            poseStack.method_22907(class_7833.field_40717.rotationDegrees(180));
            class_4588 buffer = pBuffer.getBuffer(class_1921.method_23580(class_1047.method_4539()));
            SLOT_BLOCK_MODEL.method_2828(poseStack, buffer, pPackedLight, pPackedOverlay, 1, 1, 1, 1);
        });
    }
}
