package com.tacz.guns.client.resource.serialize;

import cn.sh1rocu.tacz.util.forge.CraftingHelper;
import com.google.gson.*;
import java.lang.reflect.Type;
import net.minecraft.class_1799;

public class ItemStackSerializer implements JsonDeserializer<class_1799> {
    @Override
    public class_1799 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonObject()) {
            JsonObject jsonObject = json.getAsJsonObject();
            return CraftingHelper.getItemStack(jsonObject, true, false);
        } else {
            throw new JsonSyntaxException("Expected " + json + " to be a ItemStack because it's not an object");
        }
    }
}