package com.tacz.guns.compat.kubejs.events;

import cn.sh1rocu.tacz.api.event.BaseEvent;
import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.event.Extra;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import dev.latvian.mods.kubejs.script.ScriptTypePredicate;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public interface TimelessKubeJSEventRegister {
    default void init() {
    }

    Map<Class<? extends BaseEvent>, Consumer<BaseEvent>> getEventHandlers();

    ScriptTypePredicate getScriptType();

    default <E extends BaseEvent> EventHandler registerTimelessEvent(
            String id,
            Class<? extends GunKubeJSEvents.GunEventJS<E>> eventJSClass,
            Class<E> eventClass,
            Function<E, ? extends GunKubeJSEvents.GunEventJS<E>> eventJSFactory
    ) {
        return registerTimelessEvent(id, eventJSClass, eventClass, eventJSFactory, false);
    }

    default <E extends BaseEvent> EventHandler registerTimelessEvent(
            String id,
            Class<? extends GunKubeJSEvents.GunEventJS<E>> eventJSClass,
            Class<E> eventClass,
            Function<E, ? extends GunKubeJSEvents.GunEventJS<E>> eventJSFactory,
            boolean hasResult
    ) {
        EventHandler handler = registerEventJS(id, eventJSClass, hasResult);
        registerEventHandler(eventClass, (event) -> {
            GunKubeJSEvents.GunEventJS<E> eventJS = eventJSFactory.apply((E) event);
            handler.post(eventJS, eventJS.getEventSubId());
        });
        return handler;
    }

    default <E extends BaseEvent> EventHandler registerTimelessCommonEvent(
            String id,
            Class<? extends GunKubeJSEvents.GunEventJS<E>> eventJSClass,
            Class<E> eventClass,
            Function<E, ? extends GunKubeJSEvents.GunEventJS<E>> eventJSFactory
    ) {
        return registerTimelessCommonEvent(id, eventJSClass, eventClass, eventJSFactory, false);
    }

    default <E extends BaseEvent> EventHandler registerTimelessCommonEvent(
            String id,
            Class<? extends GunKubeJSEvents.GunEventJS<E>> eventJSClass,
            Class<E> eventClass,
            Function<E, ? extends GunKubeJSEvents.GunEventJS<E>> eventJSFactory,
            boolean hasResult
    ) {
        EventHandler handler = registerEventJS(id, eventJSClass, hasResult);
        registerEventHandler(eventClass, (event) -> {
            GunKubeJSEvents.GunEventJS<E> eventJS = eventJSFactory.apply((E) event);
            ScriptTypeHolder holder = eventJS.getTypeHolder();
            if (holder != null) {
                handler.post(holder, eventJS.getEventSubId(), eventJS);
            } else {
                throw new IllegalArgumentException("You must specify which script type to post event to");
            }
        });
        return handler;
    }

    default <E extends BaseEvent> EventHandler registerEventJS(String id, Class<? extends GunKubeJSEvents.GunEventJS<E>> eventJSClass, boolean hasResult) {
        return hasResult ? GunKubeJSEvents.GROUP.add(id, getScriptType(), () -> eventJSClass).extra(Extra.ID).hasResult() : GunKubeJSEvents.GROUP.add(id, getScriptType(), () -> eventJSClass).extra(Extra.ID);
    }

    <E extends BaseEvent> void registerEventHandler(Class<E> eventClass, Consumer<BaseEvent> eventPoster);

    default boolean postKubeJSEvent(BaseEvent event) {
        Consumer<BaseEvent> eventHandler = getEventHandlers().get(event.getClass());
        if (eventHandler != null) {
            eventHandler.accept(event);
            return false;
        } else {
            return true;
        }
    }
}
