package com.tacz.guns.entity;

import cn.sh1rocu.tacz.api.LogicalSide;
import cn.sh1rocu.tacz.api.extension.IMinecart;
import com.mojang.authlib.GameProfile;
import com.tacz.guns.api.entity.ITargetEntity;
import com.tacz.guns.api.event.common.EntityHurtByGunEvent;
import com.tacz.guns.config.client.RenderConfig;
import com.tacz.guns.config.common.OtherConfig;
import com.tacz.guns.init.ModBlocks;
import com.tacz.guns.init.ModItems;
import com.tacz.guns.init.ModSounds;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.event.ServerMessageGunHurt;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2631;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3966;
import net.minecraft.class_8103;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import static net.minecraft.class_1688.class_1689.field_7674;

public class TargetMinecart extends class_1688 implements ITargetEntity, IMinecart {
    public static class_1299<TargetMinecart> TYPE = class_1299.class_1300.<TargetMinecart>method_5903(TargetMinecart::new, class_1311.field_17715)
            .method_17687(0.75F, 2.4F)
            .method_27299(8)
            .method_5905("target_minecart");

    private @Nullable GameProfile gameProfile = null;

    public TargetMinecart(class_1299<TargetMinecart> type, class_1937 world) {
        super(type, world);
    }

    public TargetMinecart(class_1937 level, double x, double y, double z) {
        super(TYPE, level, x, y, z);
    }

    @Override
    public void onProjectileHit(class_1297 entity, class_3966 result, class_1282 source, float damage) {
        if (this.method_37908().method_8608() || this.method_31481()) {
            return;
        }
        if (!(source.method_48790())) {
            return;
        }
        class_1297 sourceEntity = source.method_5529();
        if (sourceEntity instanceof class_1657 player) {
            this.method_7524(-1);
            this.method_7509(10);
            this.method_5785();
            this.method_7520(10);
            double dis = this.method_19538().method_1022(sourceEntity.method_19538());
            player.method_7353(class_2561.method_43469("message.tacz.target_minecart.hit", String.format("%.1f", damage), String.format("%.2f", dis)), true);
            // 原版的声音传播距离由 volume 决定
            // 当声音大于 1 时，距离为 = 16 * volume
            float volume = OtherConfig.TARGET_SOUND_DISTANCE.get() / 16.0f;
            volume = Math.max(volume, 0);
            method_37908().method_43129(null, this, ModSounds.TARGET_HIT, class_3419.field_15245, volume, this.method_37908().field_9229.method_43057() * 0.1F + 0.9F);

            if (entity instanceof EntityKineticBullet projectile) {
                boolean isHeadshot = false;
                float headshotMultiplier = 1;
                EntityHurtByGunEvent.Post event = new EntityHurtByGunEvent.Post(projectile, this, player, projectile.getGunId(), projectile.getGunDisplayId(), damage, Pair.of(source, source), isHeadshot, headshotMultiplier, LogicalSide.SERVER);
                EntityHurtByGunEvent.POST.invoker().post(event);
                NetworkHandler.sendToDimension(new ServerMessageGunHurt(projectile.method_5628(), this.method_5628(), player.method_5628(), projectile.getGunId(), projectile.getGunDisplayId(), damage, isHeadshot, headshotMultiplier), this);
            }
        }
    }

    @Override
    public boolean method_5679(class_1282 source) {
        return source.method_48789(class_8103.field_42249) || super.method_5679(source);
    }

    @Override
    public boolean tacz$canBeRidden() {
        return false;
    }

    @Override
    public boolean method_5640(double distance) {
        double size = this.method_5829().method_995();
        if (Double.isNaN(size)) {
            size = 1.0;
        }
        size *= RenderConfig.TARGET_RENDER_DISTANCE.get() * method_5824();
        return distance < size * size;
    }

    @Override
    public void method_7516(class_1282 source) {
        this.method_5650(class_1297.class_5529.field_26998);
        if (this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
            class_1799 itemStack = new class_1799(ModItems.TARGET_MINECART);
            if (this.method_16914()) {
                itemStack.method_7977(this.method_5797());
            }
            this.method_5775(itemStack);
        }
    }

    @Override
    protected @NotNull class_1792 method_42670() {
        return ModItems.TARGET_MINECART;
    }

    @Override
    public class_1799 method_31480() {
        class_1799 itemStack = new class_1799(ModItems.TARGET_MINECART);
        if (this.method_16914()) {
            itemStack.method_7977(this.method_5797());
        }
        return itemStack;
    }

    @Nullable
    public GameProfile getGameProfile() {
        if (this.gameProfile == null && this.method_5797() != null) {
            this.gameProfile = new GameProfile(null, this.method_5797().getString());
            class_2631.method_11335(this.gameProfile, gameProfile -> this.gameProfile = gameProfile);
        }
        return gameProfile;
    }

    @Override
    @NotNull
    public class_2680 method_7517() {
        return ModBlocks.TARGET.method_9564();
    }

    @NotNull
    @Override
    public class_1689 method_7518() {
        return field_7674;
    }

    @Override
    protected double method_7504() {
        return 0.2F;
    }
}
