package com.tacz.guns.network.message.event;

import cn.sh1rocu.tacz.api.LogicalSide;
import com.tacz.guns.GunMod;
import com.tacz.guns.api.event.common.EntityKillByGunEvent;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;
import javax.annotation.Nullable;

public class ServerMessageGunKill implements FabricPacket {
    public static final PacketType<ServerMessageGunKill> TYPE = PacketType.create(new class_2960(GunMod.MOD_ID, "s2c_gunkill"), ServerMessageGunKill::new);

    private final int bulletId;
    private final int killEntityId;
    private final int attackerId;
    private final class_2960 gunId;
    private final class_2960 gunDisplayId;
    private final boolean isHeadShot;
    private final float baseDamage;
    private final float headshotMultiplier;

    public ServerMessageGunKill(class_2540 buf) {
        this(
                buf.readInt(), buf.readInt(), buf.readInt(),
                buf.method_10810(), buf.method_10810(),
                buf.readFloat(), buf.readBoolean(), buf.readFloat()
        );
    }

    public ServerMessageGunKill(int bulletId, int killEntityId, int attackerId, class_2960 gunId, class_2960 gunDisplayId, float baseDamage, boolean isHeadShot, float headshotMultiplier) {
        this.bulletId = bulletId;
        this.killEntityId = killEntityId;
        this.attackerId = attackerId;
        this.gunId = gunId;
        this.gunDisplayId = gunDisplayId;
        this.baseDamage = baseDamage;
        this.isHeadShot = isHeadShot;
        this.headshotMultiplier = headshotMultiplier;
    }

    @Override
    public void write(class_2540 buf) {
        buf.writeInt(bulletId);
        buf.writeInt(killEntityId);
        buf.writeInt(attackerId);
        buf.method_10812(gunId);
        buf.method_10812(gunDisplayId);
        buf.writeFloat(baseDamage);
        buf.writeBoolean(isHeadShot);
        buf.writeFloat(headshotMultiplier);
    }

    @Override
    public PacketType<?> getType() {
        return TYPE;
    }

    @Environment(EnvType.CLIENT)
    public void handle(class_746 player, PacketSender responseSender) {
        onKill(this);
    }

    @Environment(EnvType.CLIENT)
    private static void onKill(ServerMessageGunKill message) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        @Nullable class_1297 bullet = level.method_8469(message.bulletId);
        @Nullable class_1309 killedEntity = level.method_8469(message.killEntityId) instanceof class_1309 livingEntity ? livingEntity : null;
        @Nullable class_1309 attacker = level.method_8469(message.attackerId) instanceof class_1309 livingEntity ? livingEntity : null;
        EntityKillByGunEvent event = new EntityKillByGunEvent(bullet, killedEntity, attacker, message.gunId, message.gunDisplayId, message.baseDamage, null, message.isHeadShot, message.headshotMultiplier, LogicalSide.CLIENT);
        EntityKillByGunEvent.CALLBACK.invoker().post(event);
    }
}
