package com.tacz.guns.compat.cloth.widget;

import com.tacz.guns.client.renderer.crosshair.CrosshairType;
import me.shedaniel.clothconfig2.gui.entries.DropdownBoxEntry;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5481;

public class CrosshairDropdown {
    public static DropdownBoxEntry.SelectionTopCellElement<CrosshairType> of(CrosshairType type) {
        return new DropdownBoxEntry.DefaultSelectionTopCellElement<>(type, name -> {
            for (CrosshairType crosshairType : CrosshairType.values()) {
                if (crosshairType.name().equals(name)) {
                    return crosshairType;
                }
            }
            return null;
        }, id -> class_2561.method_43470(id.toString())) {
            @Override
            public void render(class_332 graphics, int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
                this.textFieldWidget.method_46421(x + 4);
                this.textFieldWidget.method_46419(y + 6);
                this.textFieldWidget.method_25358(width - 4 - 20);
                this.textFieldWidget.method_1888(this.getParent().isEditable());
                this.textFieldWidget.method_1868(this.getPreferredTextColor());
                this.textFieldWidget.method_25394(graphics, mouseX, mouseY, delta);

                class_2960 location = CrosshairType.getTextureLocation(this.value);
                graphics.method_25290(location, x + width - 18, y + 2, 0, 0, 16, 16, 16, 16);
            }
        };
    }

    public static DropdownBoxEntry.SelectionCellCreator<CrosshairType> of() {
        return new DropdownBoxEntry.DefaultSelectionCellCreator<>(i -> class_2561.method_43470(i.name())) {
            @Override
            public DropdownBoxEntry.SelectionCellElement<CrosshairType> create(CrosshairType selection) {
                return new DropdownBoxEntry.DefaultSelectionCellElement<>(selection, this.toTextFunction) {
                    @Override
                    public void render(class_332 graphics, int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
                        this.rendering = true;
                        this.x = x;
                        this.y = y;
                        this.width = width;
                        this.height = height;
                        boolean isHover = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
                        if (isHover) {
                            graphics.method_25294(x + 1, y + 1, x + width - 1, y + height - 1, 0xff191919);
                        }
                        class_5481 text = this.toTextFunction.apply(this.r).method_30937();
                        int color = isHover ? 0xffffff : 0x888888;
                        graphics.method_51430(class_310.method_1551().field_1772, text, (int) (x + 6 + 18), (int) (y + 6), color, false);

                        class_2960 location = CrosshairType.getTextureLocation(this.r);
                        graphics.method_25290(location, x + 4, y + 2, 0, 0, 16, 16, 16, 16);
                    }
                };
            }

            @Override
            public int getCellHeight() {
                return 20;
            }

            @Override
            public int getCellWidth() {
                return 146;
            }

            @Override
            public int getDropBoxMaxHeight() {
                return this.getCellHeight() * CrosshairType.values().length;
            }
        };
    }
}
