package com.tacz.guns.mixin.client;

import com.tacz.guns.api.client.other.KeepingItemRenderer;
import com.tacz.guns.api.item.IGun;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_630;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_591.class)
public class PlayerModelMixin<T extends class_1309> extends class_572<T> {
    @Shadow
    @Final
    public class_630 leftSleeve;
    @Shadow
    @Final
    public class_630 rightSleeve;

    public PlayerModelMixin(class_630 part) {
        super(part);
    }

    @Inject(method = "setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V", at = @At(value = "TAIL"))
    private void setRotationAnglesTail(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (!(entityIn instanceof class_1657 player)) {
            return;
        }

        // 用于清除默认的手臂旋转
        // 当第一人称渲染是，ageInTicks 正好是 0
        class_1799 currentItem = KeepingItemRenderer.getRenderer().getCurrentItem();
        if (ageInTicks == 0F && IGun.getIGunOrNull(currentItem) != null) {
            tacz$resetAll(this.field_3401);
            tacz$resetAll(this.field_27433);
            this.rightSleeve.method_17138(this.field_3401);
            this.leftSleeve.method_17138(this.field_27433);
        }
    }

    /**
     * 将给定模型的旋转角度和旋转点重置为零
     */
    @Unique
    private void tacz$resetAll(class_630 part) {
        part.field_3654 = 0.0F;
        part.field_3675 = 0.0F;
        part.field_3674 = 0.0F;
    }
}