package com.tacz.guns.network.message;

import com.tacz.guns.GunMod;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ClientMessageSyncBaseTimestamp implements class_8710 {
    public static final ClientMessageSyncBaseTimestamp INSTANCE = new ClientMessageSyncBaseTimestamp();
    public static final class_8710.class_9154<ClientMessageSyncBaseTimestamp> TYPE = new class_8710.class_9154<>(
            class_2960.method_60655(GunMod.MOD_ID, "client_sync_base_timestamp")
    );
    public static final class_9139<class_9129, ClientMessageSyncBaseTimestamp> STREAM_CODEC = class_9139.method_56431(INSTANCE);

    @Override
    public @NotNull class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    private static final Marker MARKER = MarkerFactory.getMarker("SYNC_BASE_TIMESTAMP");

    public static void handle(ClientMessageSyncBaseTimestamp message, ServerPlayNetworking.Context context) {
        long timestamp = System.currentTimeMillis();
        context.server().execute(() -> {
            class_3222 entity = context.player();
            ShooterDataHolder dataHolder = IGunOperator.fromLivingEntity(entity).getDataHolder();
            dataHolder.baseTimestamp = timestamp;
            GunMod.LOGGER.debug(MARKER, "Update server base timestamp: {}", dataHolder.baseTimestamp);
        });
    }
}