package com.tacz.guns.resource.manager;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.tacz.guns.GunMod;
import com.tacz.guns.util.ResourceScanner;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7654;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

import java.util.Locale;
import java.util.Map;

/**
 * 通用数据管理器<br>
 * 从资源包/数据包中读取json文件并解析为数据
 *
 * @param <T> 数据类型
 */
public class JsonDataManager<T> extends class_4080<Map<class_2960, JsonElement>> implements IdentifiableResourceReloadListener {
    protected final Map<class_2960, T> dataMap = Maps.newHashMap();

    private final Gson gson;
    private final Class<T> dataClass;
    private final Marker marker;

    private final class_7654 fileToIdConverter;

    public final class_2960 ID;

    public JsonDataManager(Class<T> dataClass, Gson pGson, String directory, String marker) {
        this(dataClass, pGson, class_7654.method_45114(directory), marker);
    }

    public JsonDataManager(Class<T> dataClass, Gson pGson, class_7654 fileToIdConverter, String marker) {
        this.gson = pGson;
        this.dataClass = dataClass;
        this.marker = MarkerFactory.getMarker(marker);
        this.ID = class_2960.method_60655(GunMod.MOD_ID, marker.toLowerCase(Locale.ROOT));
        this.fileToIdConverter = fileToIdConverter;
    }

    @NotNull
    @Override
    protected Map<class_2960, JsonElement> method_18789(class_3300 pResourceManager, class_3695 pProfiler) {
        return ResourceScanner.scanDirectory(pResourceManager, fileToIdConverter, this.gson);
    }

    @Override
    protected void apply(Map<class_2960, JsonElement> pObject, class_3300 pResourceManager, class_3695 pProfiler) {
        dataMap.clear();
        for (Map.Entry<class_2960, JsonElement> entry : pObject.entrySet()) {
            class_2960 id = entry.getKey();
            JsonElement element = entry.getValue();
            try {
                T data = parseJson(element);
                if (data != null) {
                    dataMap.put(id, data);
                }
            } catch (JsonParseException | IllegalArgumentException e) {
                GunMod.LOGGER.error(marker, "Failed to load data file {}", id, e);
            }
        }
    }

    protected T parseJson(JsonElement element) {
        return gson.fromJson(element, getDataClass());
    }

    public Class<T> getDataClass() {
        return dataClass;
    }

    public Marker getMarker() {
        return marker;
    }

    public Gson getGson() {
        return gson;
    }

    public T getData(class_2960 id) {
        return dataMap.get(id);
    }

    public Map<class_2960, T> getAllData() {
        return dataMap;
    }

    @Override
    public class_2960 getFabricId() {
        return this.ID;
    }
}
