/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2105;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6885;
import net.minecraft.class_6898;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9279;
import net.minecraft.class_9326;
import net.minecraft.class_9334;

public class NBTIngredient
implements CustomIngredient {
    public static final Codec<class_6885<class_1792>> ITEM_HOLDER_SET_CODEC = class_6898.method_40388((class_5321)class_7924.field_41197, (Codec)class_7923.field_41178.method_40294(), (boolean)false);
    public static final MapCodec<NBTIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ITEM_HOLDER_SET_CODEC.fieldOf("items").forGetter(NBTIngredient::items), (App)class_2522.field_51469.fieldOf("nbt").forGetter(NBTIngredient::nbt), (App)Codec.BOOL.optionalFieldOf("partial", (Object)true).forGetter(NBTIngredient::partial)).apply((Applicative)builder, NBTIngredient::new));
    public static final class_9139<class_9129, NBTIngredient> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.method_56896(ITEM_HOLDER_SET_CODEC), NBTIngredient::items, (class_9139)class_9135.field_48556, NBTIngredient::nbt, (class_9139)class_9135.field_48547, NBTIngredient::partial, NBTIngredient::new);
    private final class_6885<class_1792> items;
    private final class_2487 nbt;
    private final class_2105 predicate;
    private final boolean partial;
    private final class_1799[] stacks;
    public static final class_2960 ID = class_2960.method_60655((String)"tacz", (String)"nbt");

    public NBTIngredient(class_6885<class_1792> items, class_2487 nbt, boolean partial) {
        this.items = items;
        this.nbt = nbt;
        this.predicate = new class_2105(nbt);
        this.partial = partial;
        class_9326 patch = class_9326.method_57841().method_57854(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)nbt)).method_57852();
        this.stacks = (class_1799[])items.method_40239().map(i -> new class_1799(i, 1, patch)).toArray(class_1799[]::new);
    }

    public boolean test(@Nullable class_1799 itemStack) {
        class_2487 nbt;
        if (itemStack == null) {
            return false;
        }
        if (!this.items.method_40241(itemStack.method_41409())) {
            return false;
        }
        class_9279 data = (class_9279)itemStack.method_57824(class_9334.field_49628);
        class_2487 class_24872 = nbt = data != null ? data.method_57461() : null;
        if (this.partial) {
            return this.predicate.method_9077((class_2520)nbt);
        }
        return Objects.equals(nbt, this.nbt);
    }

    public List<class_1799> getMatchingStacks() {
        return Arrays.stream(this.stacks).toList();
    }

    public boolean requiresTesting() {
        return true;
    }

    public CustomIngredientSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public class_6885<class_1792> items() {
        return this.items;
    }

    public class_2487 nbt() {
        return this.nbt;
    }

    public boolean partial() {
        return this.partial;
    }

    public static class Serializer
    implements CustomIngredientSerializer<NBTIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public class_2960 getIdentifier() {
            return ID;
        }

        public MapCodec<NBTIngredient> getCodec(boolean b) {
            return CODEC;
        }

        public class_9139<class_9129, NBTIngredient> getPacketCodec() {
            return STREAM_CODEC;
        }
    }
}

