/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.event;

import cn.sh1rocu.tacz.api.event.ComputeFovModifierEvent;
import cn.sh1rocu.tacz.api.event.ViewportEvent;
import cn.sh1rocu.tacz.api.extension.IItem;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.event.BeforeRenderHandEvent;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.client.other.KeepingItemRenderer;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.event.common.GunFireEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.api.item.nbt.AttachmentItemDataAccessor;
import com.tacz.guns.api.modifier.ParameterizedCache;
import com.tacz.guns.api.modifier.ParameterizedCachePair;
import com.tacz.guns.client.renderer.item.AnimateGeoItemRenderer;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.config.client.RenderConfig;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.custom.RecoilModifier;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.util.math.MathUtil;
import com.tacz.guns.util.math.SecondOrderDynamics;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_746;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;

@Environment(value=EnvType.CLIENT)
public class CameraSetupEvent {
    public static final SecondOrderDynamics WORLD_FOV_DYNAMICS = new SecondOrderDynamics(0.5f, 1.2f, 0.5f, 0.0f);
    public static final SecondOrderDynamics ITEM_MODEL_FOV_DYNAMICS = new SecondOrderDynamics(0.5f, 1.2f, 0.5f, 0.0f);
    private static PolynomialSplineFunction pitchSplineFunction;
    private static PolynomialSplineFunction yawSplineFunction;
    private static long shootTimeStamp;
    private static double xRotO;
    private static double yRotO;

    public static void applyLevelCameraAnimation(ViewportEvent.ComputeCameraAngles event) {
        IItem item;
        if (!((Boolean)class_310.method_1551().field_1690.method_42448().method_41753()).booleanValue()) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_1799 stack = KeepingItemRenderer.getRenderer().getCurrentItem();
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof IItem && (class_17922 = (item = (IItem)class_17922).getCustomRenderer()) instanceof AnimateGeoItemRenderer) {
            AnimateGeoItemRenderer renderer = (AnimateGeoItemRenderer)class_17922;
            renderer.applyLevelCameraAnimation(event, stack, player);
        }
    }

    public static void applyItemInHandCameraAnimation(BeforeRenderHandEvent event) {
        IItem item;
        if (!((Boolean)class_310.method_1551().field_1690.method_42448().method_41753()).booleanValue()) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_1799 stack = KeepingItemRenderer.getRenderer().getCurrentItem();
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof IItem && (class_17922 = (item = (IItem)class_17922).getCustomRenderer()) instanceof AnimateGeoItemRenderer) {
            AnimateGeoItemRenderer renderer = (AnimateGeoItemRenderer)class_17922;
            renderer.applyItemInHandCameraAnimation(event, stack, player);
        }
    }

    public static void applyScopeMagnification(ViewportEvent.ComputeFov event) {
        if (!event.usedConfiguredFov()) {
            return;
        }
        class_1297 entity = event.getCamera().method_19331();
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            class_1799 stack = KeepingItemRenderer.getRenderer().getCurrentItem();
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof IGun)) {
                float fov = WORLD_FOV_DYNAMICS.update((float)event.getFOV());
                event.setFOV(fov);
                return;
            }
            IGun iGun = (IGun)class_17922;
            float zoom = iGun.getAimingZoom(stack);
            if (livingEntity instanceof class_746) {
                class_746 localPlayer = (class_746)livingEntity;
                IClientPlayerGunOperator gunOperator = IClientPlayerGunOperator.fromLocalPlayer(localPlayer);
                float aimingProgress = gunOperator.getClientAimingProgress((float)event.getPartialTick());
                float fov = WORLD_FOV_DYNAMICS.update((float)MathUtil.magnificationToFov(1.0f + (zoom - 1.0f) * aimingProgress, event.getFOV()));
                event.setFOV(fov);
            } else {
                IGunOperator gunOperator = IGunOperator.fromLivingEntity(livingEntity);
                float aimingProgress = gunOperator.getSynAimingProgress();
                float fov = WORLD_FOV_DYNAMICS.update((float)MathUtil.magnificationToFov(1.0f + (zoom - 1.0f) * aimingProgress, event.getFOV()));
                event.setFOV(fov);
            }
        }
    }

    public static void applyGunModelFovModifying(ViewportEvent.ComputeFov event) {
        if (event.usedConfiguredFov()) {
            return;
        }
        class_1297 entity = event.getCamera().method_19331();
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            class_1799 stack = KeepingItemRenderer.getRenderer().getCurrentItem();
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof IGun)) {
                float fov = ITEM_MODEL_FOV_DYNAMICS.update((float)event.getFOV());
                event.setFOV(fov);
                return;
            }
            IGun iGun = (IGun)class_17922;
            class_2960 scopeItemId = iGun.getAttachmentId(stack, AttachmentType.SCOPE);
            if (scopeItemId.equals((Object)DefaultAssets.EMPTY_ATTACHMENT_ID)) {
                scopeItemId = iGun.getBuiltInAttachmentId(stack, AttachmentType.SCOPE);
            }
            class_2487 scopeTag = iGun.getAttachmentTag(stack, AttachmentType.SCOPE);
            int zoomNumber = AttachmentItemDataAccessor.getZoomNumberFromTag(scopeTag);
            float modifiedFov = TimelessAPI.getClientAttachmentIndex(scopeItemId).map(index -> {
                float[] viewsFov = index.getViewsFov();
                return Float.valueOf(viewsFov[zoomNumber % viewsFov.length]);
            }).orElse(TimelessAPI.getGunDisplay(stack).map(GunDisplayInstance::getZoomModelFov).orElse(Float.valueOf((float)event.getFOV()))).floatValue();
            if (livingEntity instanceof class_746) {
                class_746 localPlayer = (class_746)livingEntity;
                IClientPlayerGunOperator gunOperator = IClientPlayerGunOperator.fromLocalPlayer(localPlayer);
                float aimingProgress = gunOperator.getClientAimingProgress((float)event.getPartialTick());
                float fov = ITEM_MODEL_FOV_DYNAMICS.update(class_3532.method_16439((float)aimingProgress, (float)((float)event.getFOV()), (float)modifiedFov));
                event.setFOV(fov);
            } else {
                IGunOperator gunOperator = IGunOperator.fromLivingEntity(livingEntity);
                float aimingProgress = gunOperator.getSynAimingProgress();
                float fov = ITEM_MODEL_FOV_DYNAMICS.update(class_3532.method_16439((float)aimingProgress, (float)((float)event.getFOV()), (float)modifiedFov));
                event.setFOV(fov);
            }
        }
    }

    public static void initialCameraRecoil(GunFireEvent event) {
        if (event.getLogicalSide().isClient()) {
            class_746 player;
            class_1309 shooter = event.getShooter();
            if (!shooter.equals((Object)(player = class_310.method_1551().field_1724))) {
                return;
            }
            class_1799 mainHandItem = player.method_6047();
            class_1792 class_17922 = mainHandItem.method_7909();
            if (!(class_17922 instanceof IGun)) {
                return;
            }
            IGun iGun = (IGun)class_17922;
            AttachmentCacheProperty cacheProperty = IGunOperator.fromLivingEntity((class_1309)player).getCacheProperty();
            if (cacheProperty == null) {
                return;
            }
            class_2960 gunId = iGun.getGunId(mainHandItem);
            Optional<ClientGunIndex> gunIndexOptional = TimelessAPI.getClientGunIndex(gunId);
            if (gunIndexOptional.isEmpty()) {
                return;
            }
            ClientGunIndex gunIndex = gunIndexOptional.get();
            GunData gunData = gunIndex.getGunData();
            ParameterizedCachePair attachmentRecoilModifier = (ParameterizedCachePair)cacheProperty.getCache(RecoilModifier.ID);
            IClientPlayerGunOperator clientPlayerGunOperator = IClientPlayerGunOperator.fromLocalPlayer(player);
            float partialTicks = class_310.method_1551().method_60646().method_60637(false);
            float aimingProgress = clientPlayerGunOperator.getClientAimingProgress(partialTicks);
            float zoom = iGun.getAimingZoom(mainHandItem);
            float aimingRecoilModifier = 1.0f - aimingProgress + aimingProgress / (float)Math.min(Math.sqrt(zoom), 1.5);
            if (!player.method_5681() && player.method_18376() == class_4050.field_18079) {
                aimingRecoilModifier *= gunData.getCrawlRecoilMultiplier();
            }
            pitchSplineFunction = gunData.getRecoil().genPitchSplineFunction((float)((ParameterizedCache)attachmentRecoilModifier.left()).eval(aimingRecoilModifier));
            yawSplineFunction = gunData.getRecoil().genYawSplineFunction((float)((ParameterizedCache)attachmentRecoilModifier.right()).eval(aimingRecoilModifier));
            shootTimeStamp = System.currentTimeMillis();
            xRotO = 0.0;
            yRotO = 0.0;
        }
    }

    public static void applyCameraRecoil(ViewportEvent.ComputeCameraAngles event) {
        double value;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        long timeTotal = System.currentTimeMillis() - shootTimeStamp;
        if (pitchSplineFunction != null && pitchSplineFunction.isValidPoint((double)timeTotal)) {
            value = pitchSplineFunction.value((double)timeTotal);
            player.method_36457(player.method_36455() - (float)(value - xRotO));
            xRotO = value;
        }
        if (yawSplineFunction != null && yawSplineFunction.isValidPoint((double)timeTotal)) {
            value = yawSplineFunction.value((double)timeTotal);
            player.method_36456(player.method_36454() - (float)(value - yRotO));
            yRotO = value;
        }
    }

    public static void onComputeMovementFov(ComputeFovModifierEvent event) {
        if (!((Boolean)RenderConfig.DISABLE_MOVEMENT_ATTRIBUTE_FOV.get()).booleanValue()) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        float f = 1.0f;
        if (player.method_6047().method_7909() instanceof AbstractGunItem) {
            if (player.method_31549().field_7479) {
                f *= 1.1f;
            }
            event.setNewFovModifier(player.method_5624() ? 1.15f * f : f);
        }
    }

    static {
        shootTimeStamp = -1L;
        xRotO = 0.0;
        yRotO = 0.0;
    }
}

