/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gameplay;

import cn.sh1rocu.tacz.api.LogicalSide;
import cn.sh1rocu.tacz.api.extension.IItem;
import cn.sh1rocu.tacz.mixin.accessor.BlockableEventLoopAccessor;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.event.common.GunDrawEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.gameplay.LocalPlayerDataHolder;
import com.tacz.guns.client.renderer.item.AnimateGeoItemRenderer;
import com.tacz.guns.client.sound.SoundPlayManager;
import com.tacz.guns.network.message.ClientMessagePlayerDrawGun;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.minecraft.class_8710;

public class LocalPlayerDraw {
    private final LocalPlayerDataHolder data;
    private final class_746 player;
    public boolean readyToDraw = false;

    public LocalPlayerDraw(LocalPlayerDataHolder data, class_746 player) {
        this.data = data;
        this.player = player;
    }

    public void draw(class_1799 lastItem) {
        this.resetData();
        class_1799 currentItem = this.player.method_6047();
        long drawTime = System.currentTimeMillis() - this.data.clientDrawTimestamp;
        IGun currentGun = IGun.getIGunOrNull(currentItem);
        IGun lastGun = IGun.getIGunOrNull(lastItem);
        if (drawTime >= 0L) {
            drawTime = this.getDrawTime(lastItem, lastGun, drawTime);
        }
        long putAwayTime = Math.abs(drawTime);
        if (class_310.method_1551().field_1761 != null) {
            class_310.method_1551().field_1761.method_2911();
        }
        ClientPlayNetworking.send((class_8710)ClientMessagePlayerDrawGun.INSTANCE);
        ((GunDrawEvent.Callback)GunDrawEvent.CALLBACK.invoker()).post(new GunDrawEvent((class_1309)this.player, lastItem, currentItem, LogicalSide.CLIENT));
        if (drawTime >= 0L) {
            this.doPutAway(lastItem, putAwayTime);
        }
        if (currentGun != null) {
            this.doDraw(currentItem, putAwayTime);
            AttachmentPropertyManager.postChangeEvent((class_1309)this.player, currentItem);
        }
    }

    private void doDraw(class_1799 currentItem, long putAwayTime) {
        TimelessAPI.getGunDisplay(currentItem).ifPresent(display -> {
            if (this.data.drawFuture != null) {
                this.data.drawFuture.cancel(false);
            }
            this.data.drawFuture = LocalPlayerDataHolder.SCHEDULED_EXECUTOR_SERVICE.schedule(() -> ((BlockableEventLoopAccessor)class_310.method_1551()).tacz$submitAsync(() -> {
                SoundPlayManager.stopPlayGunSound();
                SoundPlayManager.playDrawSound((class_1309)this.player, display);
            }), putAwayTime, TimeUnit.MILLISECONDS);
        });
    }

    private void doPutAway(class_1799 lastItem, long putAwayTime) {
        IItem item;
        class_1792 class_17922 = lastItem.method_7909();
        if (class_17922 instanceof IItem && (class_17922 = (item = (IItem)class_17922).getCustomRenderer()) instanceof AnimateGeoItemRenderer) {
            AnimateGeoItemRenderer renderer = (AnimateGeoItemRenderer)class_17922;
            renderer.tryExit(lastItem, putAwayTime);
        }
        TimelessAPI.getGunDisplay(lastItem).ifPresent(display -> ((BlockableEventLoopAccessor)class_310.method_1551()).tacz$submitAsync(() -> {
            SoundPlayManager.stopPlayGunSound();
            SoundPlayManager.playPutAwaySound((class_1309)this.player, display);
        }));
    }

    private long getDrawTime(class_1799 lastItem, IGun lastGun, long drawTime) {
        IItem item;
        class_1792 class_17922 = lastItem.method_7909();
        if (class_17922 instanceof IItem && (class_17922 = (item = (IItem)class_17922).getCustomRenderer()) instanceof AnimateGeoItemRenderer) {
            AnimateGeoItemRenderer renderer = (AnimateGeoItemRenderer)class_17922;
            long putAwayTime = renderer.getPutAwayTime(lastItem);
            if (drawTime > putAwayTime) {
                drawTime = putAwayTime;
            }
            this.data.clientDrawTimestamp = System.currentTimeMillis() + drawTime;
        } else {
            drawTime = 0L;
            this.data.clientDrawTimestamp = System.currentTimeMillis();
        }
        return drawTime;
    }

    private void resetData() {
        this.data.lockState(operator -> operator.getSynDrawCoolDown() > 0L);
        this.data.isShootRecorded = true;
        this.data.clientShootTimestamp = -1L;
        this.data.clientIsAiming = false;
        this.data.clientAimingProgress = 0.0f;
        LocalPlayerDataHolder.oldAimingProgress = 0.0f;
        this.data.isBolting = false;
        if (this.data.clientDrawTimestamp == -1L) {
            this.data.clientDrawTimestamp = System.currentTimeMillis();
        }
    }
}

