/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.model;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.client.model.BedrockAnimatedModel;
import com.tacz.guns.client.model.bedrock.BedrockPart;
import com.tacz.guns.client.model.bedrock.ModelRendererWrapper;
import com.tacz.guns.client.model.functional.BeamRenderer;
import com.tacz.guns.client.model.functional.TextShowRender;
import com.tacz.guns.client.resource.pojo.display.gun.TextShow;
import com.tacz.guns.client.resource.pojo.model.BedrockModelPOJO;
import com.tacz.guns.client.resource.pojo.model.BedrockVersion;
import com.tacz.guns.compat.iris.IrisCompat;
import com.tacz.guns.util.RenderHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import net.minecraft.class_811;
import net.minecraft.class_9801;
import org.joml.Vector3f;

public class BedrockAttachmentModel
extends BedrockAnimatedModel {
    private static final String SCOPE_VIEW_NODE = "scope_view";
    private static final String SCOPE_BODY_NODE = "scope_body";
    private static final String OCULAR_RING_NODE = "ocular_ring";
    private static final String DIVISION_NODE = "division";
    private static final String OCULAR_NODE = "ocular";
    private static final String OCULAR_SIGHT_NODE = "ocular_sight";
    private static final String OCULAR_SCOPE_NODE = "ocular_scope";
    private static final Pattern LASER_BEAM_PATTERN = Pattern.compile("^laser_beam(_(\\d+))?$");
    protected List<List<BedrockPart>> scopeViewPaths = new ArrayList<List<BedrockPart>>();
    @Nullable
    protected List<BedrockPart> scopeBodyPath;
    @Nullable
    protected List<BedrockPart> ocularRingPath;
    protected List<List<BedrockPart>> ocularNodePaths = new ArrayList<List<BedrockPart>>();
    protected List<Boolean> isScopeOcular = new ArrayList<Boolean>();
    protected List<List<BedrockPart>> divisionNodePaths = new ArrayList<List<BedrockPart>>();
    @Nullable
    protected List<List<BedrockPart>> laserBeamPaths = new ArrayList<List<BedrockPart>>();
    @Nullable
    private class_1799 currentGunItem;
    @Nullable
    private class_1799 attachmentItem;
    private boolean isScope = false;
    private boolean isSight = false;
    private float scopeViewRadiusModifier = 1.0f;

    public BedrockAttachmentModel(BedrockModelPOJO pojo, BedrockVersion version) {
        super(pojo, version);
        List<BedrockPart> path = this.getPath((ModelRendererWrapper)this.modelMap.get(SCOPE_VIEW_NODE));
        int i = 2;
        while (path != null) {
            this.scopeViewPaths.add(path);
            path = this.getPath((ModelRendererWrapper)this.modelMap.get("scope_view_" + i++));
        }
        String ocularRegex = "^(ocular|ocular_sight|ocular_scope)(_(\\d+))?$";
        Pattern ocularPattern = Pattern.compile(ocularRegex);
        TreeMap<Integer, OcularWrapper> map = new TreeMap<Integer, OcularWrapper>();
        for (Map.Entry entry : this.modelMap.entrySet()) {
            Matcher matcher = ocularPattern.matcher((CharSequence)entry.getKey());
            if (matcher.matches()) {
                int num = 1;
                String numStr = matcher.group(3);
                if (numStr != null) {
                    num = Integer.parseInt(numStr);
                }
                String type = matcher.group(1);
                boolean isScope = OCULAR_SCOPE_NODE.equals(type);
                map.put(num, new OcularWrapper((ModelRendererWrapper)entry.getValue(), isScope));
            }
            if (!LASER_BEAM_PATTERN.matcher((CharSequence)entry.getKey()).find()) continue;
            this.laserBeamPaths.add(this.getPath((ModelRendererWrapper)entry.getValue()));
        }
        for (OcularWrapper wrapper : map.values()) {
            this.ocularNodePaths.add(this.getPath(wrapper.renderer));
            this.isScopeOcular.add(wrapper.isScope);
        }
        ModelRendererWrapper divisionModel = (ModelRendererWrapper)this.modelMap.get(DIVISION_NODE);
        path = this.getPath((ModelRendererWrapper)this.modelMap.get(DIVISION_NODE));
        i = 2;
        while (path != null) {
            this.divisionNodePaths.add(path);
            divisionModel.setHidden(true);
            divisionModel = (ModelRendererWrapper)this.modelMap.get("division_" + i++);
            path = this.getPath(divisionModel);
        }
        this.scopeBodyPath = this.getPath((ModelRendererWrapper)this.modelMap.get(SCOPE_BODY_NODE));
        this.ocularRingPath = this.getPath((ModelRendererWrapper)this.modelMap.get(OCULAR_RING_NODE));
    }

    @Nullable
    public List<BedrockPart> getScopeViewPath(int viewSwitchCount) {
        if (this.scopeViewPaths.isEmpty()) {
            return null;
        }
        if (viewSwitchCount >= this.scopeViewPaths.size()) {
            return this.scopeViewPaths.get(0);
        }
        return this.scopeViewPaths.get(viewSwitchCount);
    }

    public void setIsScope(boolean isScope) {
        this.isScope = isScope;
    }

    public void setIsSight(boolean isSight) {
        this.isSight = isSight;
    }

    public boolean isScope() {
        return this.isScope;
    }

    public boolean isSight() {
        return this.isSight;
    }

    public void setScopeViewRadiusModifier(float scopeViewRadiusModifier) {
        this.scopeViewRadiusModifier = scopeViewRadiusModifier;
    }

    public void setTextShowList(Map<String, TextShow> textShowList) {
        textShowList.forEach((name, textShow) -> this.setFunctionalRenderer((String)name, bedrockPart -> new TextShowRender(this, (TextShow)textShow, this.currentGunItem)));
    }

    public void render(@Nullable class_1799 attachmentItem, class_1799 currentGunItem, class_4587 matrixStack, class_811 transformType, class_1921 renderType, int light, int overlay) {
        this.currentGunItem = currentGunItem;
        this.attachmentItem = attachmentItem;
        if (transformType.method_29998()) {
            if (this.isScope && this.isSight) {
                this.renderBoth(matrixStack, transformType, renderType, light, overlay);
            } else if (this.isScope) {
                this.renderScope(matrixStack, transformType, renderType, light, overlay);
            } else if (this.isSight) {
                this.renderSight(matrixStack, transformType, renderType, light, overlay);
            }
        } else {
            if (this.scopeBodyPath != null) {
                this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.scopeBodyPath);
            }
            if (this.ocularRingPath != null) {
                this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.ocularRingPath);
            }
        }
        if (!this.isScope && !this.isSight && this.laserBeamPaths != null) {
            for (List<BedrockPart> entry : this.laserBeamPaths) {
                BeamRenderer.renderLaserBeam(attachmentItem, matrixStack, transformType, entry);
            }
        }
        super.render(matrixStack, transformType, renderType, light, overlay);
        if ((this.isScope || this.isSight) && this.laserBeamPaths != null) {
            for (List<BedrockPart> entry : this.laserBeamPaths) {
                BeamRenderer.renderLaserBeam(attachmentItem, matrixStack, transformType, entry);
            }
        }
    }

    private Vector3f getBedrockPartCenter(class_4587 poseStack, @Nonnull List<BedrockPart> path) {
        poseStack.method_22903();
        for (BedrockPart part : path) {
            part.translateAndRotateAndScale(poseStack);
        }
        Vector3f result = new Vector3f(poseStack.method_23760().method_23761().m30(), poseStack.method_23760().method_23761().m31(), poseStack.method_23760().method_23761().m32());
        poseStack.method_22909();
        return result;
    }

    private void renderTempPart(class_4587 poseStack, class_811 transformType, class_1921 renderType, int light, int overlay, @Nonnull List<BedrockPart> path) {
        poseStack.method_22903();
        for (int i = 0; i < path.size() - 1; ++i) {
            path.get(i).translateAndRotateAndScale(poseStack);
        }
        BedrockPart part = path.get(path.size() - 1);
        part.visible = true;
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        class_4588 vertexConsumer = bufferSource.getBuffer(renderType);
        part.render(poseStack, transformType, vertexConsumer, light, overlay);
        if (!IrisCompat.endBatch(bufferSource)) {
            bufferSource.method_22994(renderType);
        }
        part.visible = false;
        poseStack.method_22909();
    }

    private void renderOcularStencil(class_4587 matrixStack, class_811 transformType, class_1921 renderType, int light, int overlay, boolean isScope) {
        if (!this.ocularNodePaths.isEmpty()) {
            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            RenderSystem.depthMask((boolean)false);
            RenderSystem.stencilMask((int)255);
            RenderSystem.stencilOp((int)7680, (int)7680, (int)7681);
            for (int i = this.ocularNodePaths.size() - 1; i >= 0; --i) {
                if (isScope != this.isScopeOcular.get(i)) continue;
                RenderSystem.stencilFunc((int)516, (int)(i + 1), (int)255);
                this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.ocularNodePaths.get(i));
            }
            RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
    }

    private void renderDivisionOnly(class_4587 matrixStack, class_811 transformType, class_1921 renderType, int light, int overlay) {
        if (!this.divisionNodePaths.isEmpty()) {
            RenderSystem.disableDepthTest();
            for (int i = 0; i < this.divisionNodePaths.size(); ++i) {
                RenderSystem.stencilFunc((int)514, (int)(i + 1), (int)255);
                this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.divisionNodePaths.get(i));
            }
            RenderSystem.enableDepthTest();
        }
    }

    private void renderOcularAndDivision(class_4587 matrixStack, class_811 transformType, class_1921 renderType, int light, int overlay, boolean selective) {
        if (!this.ocularNodePaths.isEmpty()) {
            int i;
            RenderSystem.stencilOp((int)7680, (int)7680, (int)5386);
            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            RenderSystem.depthMask((boolean)false);
            float rad = 80.0f * this.scopeViewRadiusModifier;
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                rad *= IClientPlayerGunOperator.fromLocalPlayer(player).getClientAimingProgress(class_310.method_1551().method_60646().method_60637(false));
            }
            for (i = 0; i < this.ocularNodePaths.size(); ++i) {
                if (selective && !this.isScopeOcular.get(i).booleanValue()) continue;
                RenderSystem.stencilFunc((int)514, (int)(i + 1), (int)255);
                Vector3f ocularCenter = this.getBedrockPartCenter(matrixStack, this.ocularNodePaths.get(i));
                float centerX = ocularCenter.x() * 16.0f * 90.0f;
                float centerY = ocularCenter.y() * 16.0f * 90.0f;
                class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27381, class_290.field_1576);
                builder.method_22912(centerX, centerY, -90.0f).method_1336(255, 255, 255, 255);
                for (int j = 0; j <= 90; ++j) {
                    float angle = (float)j * ((float)Math.PI * 2) / 90.0f;
                    float sin = class_3532.method_15374((float)angle);
                    float cos = class_3532.method_15362((float)angle);
                    builder.method_22912(centerX + cos * rad, centerY + sin * rad, -90.0f).method_1336(255, 255, 255, 255);
                }
                class_286.method_43433((class_9801)builder.method_60800());
            }
            RenderSystem.depthMask((boolean)true);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
            for (i = 0; i < this.ocularNodePaths.size() && i < this.divisionNodePaths.size(); ++i) {
                if (i > 127) {
                    throw new IllegalArgumentException("Index of oculus is out of range for 127");
                }
                if (selective && !this.isScopeOcular.get(i).booleanValue()) {
                    RenderSystem.stencilFunc((int)514, (int)(i + 1), (int)255);
                    this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.divisionNodePaths.get(i));
                    continue;
                }
                RenderSystem.stencilFunc((int)514, (int)(i + 1), (int)255);
                this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.ocularNodePaths.get(i));
                int b = ~(i + 1) & 0xFF;
                RenderSystem.stencilFunc((int)514, (int)b, (int)255);
                this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.divisionNodePaths.get(i));
            }
        }
    }

    private void renderBoth(class_4587 matrixStack, class_811 transformType, class_1921 renderType, int light, int overlay) {
        RenderHelper.enableItemEntityStencilTest();
        RenderSystem.clearStencil((int)0);
        RenderSystem.clear((int)1024, (boolean)class_310.field_1703);
        if (this.ocularRingPath != null) {
            RenderSystem.stencilFunc((int)519, (int)0, (int)255);
            RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
            this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.ocularRingPath);
        }
        this.renderOcularStencil(matrixStack, transformType, renderType, light, overlay, true);
        if (this.scopeBodyPath != null) {
            RenderSystem.stencilFunc((int)514, (int)0, (int)255);
            this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.scopeBodyPath);
        }
        this.renderOcularStencil(matrixStack, transformType, renderType, light, overlay, false);
        this.renderOcularAndDivision(matrixStack, transformType, renderType, light, overlay, true);
        RenderSystem.stencilFunc((int)519, (int)0, (int)255);
        RenderHelper.disableItemEntityStencilTest();
        super.render(matrixStack, transformType, renderType, light, overlay);
    }

    private void renderSight(class_4587 matrixStack, class_811 transformType, class_1921 renderType, int light, int overlay) {
        RenderHelper.enableItemEntityStencilTest();
        RenderSystem.clearStencil((int)0);
        RenderSystem.clear((int)1024, (boolean)class_310.field_1703);
        this.renderOcularStencil(matrixStack, transformType, renderType, light, overlay, false);
        this.renderDivisionOnly(matrixStack, transformType, renderType, light, overlay);
        RenderSystem.stencilFunc((int)519, (int)0, (int)255);
        RenderHelper.disableItemEntityStencilTest();
        if (this.scopeBodyPath != null) {
            this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.scopeBodyPath);
        }
        super.render(matrixStack, transformType, renderType, light, overlay);
    }

    private void renderScope(class_4587 matrixStack, class_811 transformType, class_1921 renderType, int light, int overlay) {
        RenderHelper.enableItemEntityStencilTest();
        RenderSystem.clearStencil((int)0);
        RenderSystem.clear((int)1024, (boolean)class_310.field_1703);
        if (this.ocularRingPath != null) {
            RenderSystem.stencilFunc((int)519, (int)0, (int)255);
            RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
            this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.ocularRingPath);
        }
        this.renderOcularStencil(matrixStack, transformType, renderType, light, overlay, false);
        if (this.scopeBodyPath != null) {
            RenderSystem.stencilFunc((int)514, (int)0, (int)255);
            this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.scopeBodyPath);
        }
        this.renderOcularAndDivision(matrixStack, transformType, renderType, light, overlay, false);
        RenderSystem.stencilFunc((int)519, (int)0, (int)255);
        RenderHelper.disableItemEntityStencilTest();
        super.render(matrixStack, transformType, renderType, light, overlay);
    }

    private static class OcularWrapper {
        public ModelRendererWrapper renderer;
        public boolean isScope;

        public OcularWrapper(ModelRendererWrapper renderer, boolean isScope) {
            this.renderer = renderer;
            this.isScope = isScope;
        }
    }
}

