/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.crafting.result;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.builder.AmmoItemBuilder;
import com.tacz.guns.api.item.builder.AttachmentItemBuilder;
import com.tacz.guns.api.item.builder.GunItemBuilder;
import com.tacz.guns.crafting.result.GunSmithTableResult;
import com.tacz.guns.resource.pojo.data.block.TabConfig;
import com.tacz.guns.resource.pojo.data.recipe.GunResult;
import java.util.EnumMap;
import java.util.Locale;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RawGunTableResult {
    private final String type;
    private final int count;
    private final class_2960 id;
    @Nullable
    private GunResult extraData;
    @Nullable
    private class_2487 nbt;

    public RawGunTableResult(@NotNull String type, @NotNull class_2960 id, int count) {
        this.type = type;
        this.id = id;
        this.count = count;
    }

    public void setExtraData(@Nullable GunResult extraData) {
        this.extraData = extraData;
    }

    public void setNbt(@Nullable class_2487 nbt) {
        this.nbt = nbt;
    }

    public static GunSmithTableResult init(class_7225.class_7874 provider, RawGunTableResult raw) {
        GunSmithTableResult result;
        switch (raw.type) {
            case "gun": {
                GunSmithTableResult gunSmithTableResult = raw.getGunStack(provider);
                break;
            }
            case "ammo": {
                GunSmithTableResult gunSmithTableResult = raw.getAmmoStack();
                break;
            }
            case "attachment": {
                GunSmithTableResult gunSmithTableResult = raw.getAttachmentStack();
                break;
            }
            default: {
                GunSmithTableResult gunSmithTableResult = result = new GunSmithTableResult(class_1799.field_8037, TabConfig.TAB_EMPTY);
            }
        }
        if (raw.nbt != null) {
            result.getResult().method_57368(class_9334.field_49628, (Object)class_9279.field_49302, data -> data.method_57451(tag -> {
                for (String key : raw.nbt.method_10541()) {
                    class_2520 value = raw.nbt.method_10580(key);
                    if (value == null) continue;
                    tag.method_10566(key, value);
                }
            }));
        }
        return result;
    }

    private GunSmithTableResult getGunStack(class_7225.class_7874 provider) {
        EnumMap<AttachmentType, Object> attachments;
        int ammoCount;
        if (this.extraData != null) {
            ammoCount = Math.max(0, this.extraData.getAmmoCount());
            attachments = this.extraData.getAttachments();
        } else {
            ammoCount = 0;
            attachments = new EnumMap(AttachmentType.class);
        }
        return TimelessAPI.getCommonGunIndex(this.id).map(gunIndex -> {
            class_1799 itemStack = GunItemBuilder.create().setCount(this.count).setId(this.id).setAmmoCount(ammoCount).setAmmoInBarrel(false).putAllAttachment(attachments).setFireMode(gunIndex.getGunData().getFireModeSet().getFirst()).build(provider);
            Object raw = gunIndex.getType();
            if (!((String)raw).contains(":")) {
                raw = "tacz:" + (String)raw;
            }
            class_2960 group = class_2960.method_12829((String)raw);
            return new GunSmithTableResult(itemStack, group);
        }).orElse(new GunSmithTableResult(class_1799.field_8037, TabConfig.TAB_EMPTY));
    }

    private GunSmithTableResult getAmmoStack() {
        return new GunSmithTableResult(AmmoItemBuilder.create().setCount(this.count).setId(this.id).build(), TabConfig.TAB_AMMO);
    }

    private GunSmithTableResult getAttachmentStack() {
        return TimelessAPI.getCommonAttachmentIndex(this.id).map(attachmentIndex -> {
            class_1799 itemStack = AttachmentItemBuilder.create().setCount(this.count).setId(this.id).build();
            Object raw = attachmentIndex.getType().name().toLowerCase(Locale.US);
            if (!((String)raw).contains(":")) {
                raw = "tacz:" + (String)raw;
            }
            class_2960 group = class_2960.method_12829((String)raw);
            return new GunSmithTableResult(itemStack, group);
        }).orElse(new GunSmithTableResult(class_1799.field_8037, TabConfig.TAB_EMPTY));
    }
}

