/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.entity.sync.core;

import com.tacz.guns.entity.sync.core.SyncedDataKey;
import com.tacz.guns.entity.sync.core.SyncedEntityData;
import net.minecraft.class_1297;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.apache.commons.lang3.Validate;

public class DataEntry<E extends class_1297, T> {
    public static final class_9139<class_9129, DataEntry<?, ?>> STREAM_CODEC = class_9139.method_56437((buffer, entry) -> entry.write((class_2540)buffer), DataEntry::read);
    private final SyncedDataKey<E, T> key;
    private T value;
    private boolean dirty;

    public DataEntry(SyncedDataKey<E, T> key) {
        this.key = key;
        this.value = key.defaultValueSupplier().get();
    }

    public static DataEntry<?, ?> read(class_2540 buffer) {
        SyncedDataKey<?, ?> key = SyncedEntityData.instance().getKey(buffer.method_10816());
        Validate.notNull(key, (String)"Synced key does not exist for id", (Object[])new Object[0]);
        DataEntry entry = new DataEntry(key);
        entry.readValue(buffer);
        return entry;
    }

    public SyncedDataKey<E, T> getKey() {
        return this.key;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value, boolean dirty) {
        this.value = value;
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clean() {
        this.dirty = false;
    }

    public void write(class_2540 buffer) {
        int id = SyncedEntityData.instance().getInternalId(this.key);
        buffer.method_10804(id);
        this.key.serializer().write(buffer, this.value);
    }

    public void readValue(class_2540 buffer) {
        this.value = this.getKey().serializer().read(buffer);
    }

    public class_2520 writeValue(class_7225.class_7874 provider) {
        return this.key.serializer().write(provider, this.value);
    }

    public void readValue(class_7225.class_7874 provider, class_2520 nbt) {
        this.value = this.key.serializer().read(provider, nbt);
    }
}

