/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.forge;

import carbonconfiglib.gui.api.IConfigFolderNode;
import carbonconfiglib.gui.api.IConfigNode;
import carbonconfiglib.gui.impl.forge.ForgeLeaf;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.common.ForgeConfigSpec;

public class ForgeNode
implements IConfigFolderNode {
    List<String> paths;
    CommentedConfig config;
    ForgeConfigSpec spec;
    UnmodifiableConfig specConfig;
    List<IConfigNode> children;
    Component tooltip;

    public ForgeNode(List<String> paths, CommentedConfig config, ForgeConfigSpec spec) {
        this(paths, config, spec, spec.getValues());
    }

    public ForgeNode(List<String> paths, CommentedConfig config, ForgeConfigSpec spec, UnmodifiableConfig specConfig) {
        this.paths = paths;
        this.config = config;
        this.spec = spec;
        this.specConfig = specConfig;
        this.loadComment();
    }

    private void loadComment() {
        String value = this.spec.getLevelComment(this.paths);
        if (value == null) {
            return;
        }
        String[] array = value.split("\n");
        if (array != null && array.length > 0) {
            MutableComponent comp = Component.m_237119_();
            int i = 0;
            while (i < array.length) {
                comp.m_130946_("\n").m_130946_(array[i++]);
            }
            this.tooltip = comp;
        }
    }

    @Override
    public List<IConfigNode> getChildren() {
        if (this.children == null) {
            this.children = new ObjectArrayList();
            for (Map.Entry entry : this.specConfig.valueMap().entrySet()) {
                Object value = entry.getValue();
                if (value instanceof UnmodifiableConfig) {
                    ObjectArrayList list = new ObjectArrayList(this.paths);
                    list.add((String)entry.getKey());
                    this.children.add(new ForgeNode((List<String>)list, this.config, this.spec, (UnmodifiableConfig)value));
                    continue;
                }
                if (!(value instanceof ForgeConfigSpec.ConfigValue)) continue;
                this.children.add(new ForgeLeaf(this.spec, (ForgeConfigSpec.ConfigValue)value, this.config));
            }
        }
        return this.children;
    }

    @Override
    public String getNodeName() {
        return this.paths.isEmpty() ? null : ((String)Iterables.getLast(this.paths, (Object)"Root")).toLowerCase(Locale.ROOT);
    }

    @Override
    public Component getName() {
        return IConfigNode.createLabel((String)Iterables.getLast(this.paths, (Object)"Root"));
    }

    @Override
    public Component getTooltip() {
        MutableComponent comp = Component.m_237119_();
        comp.m_7220_((Component)Component.m_237113_((String)((String)Iterables.getLast(this.paths, (Object)"Root"))).m_130940_(ChatFormatting.YELLOW));
        if (this.tooltip != null) {
            comp.m_7220_(this.tooltip);
        }
        return comp;
    }

    @Override
    public boolean isRoot() {
        return this.paths.isEmpty();
    }
}

