/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.impl.internal;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.api.IConfigChangeListener;
import carbonconfiglib.config.ConfigHandler;
import carbonconfiglib.gui.api.IModConfigs;
import carbonconfiglib.gui.impl.forge.ForgeConfigs;
import carbonconfiglib.gui.impl.minecraft.MinecraftConfigs;
import carbonconfiglib.gui.screen.ConfigSelectorScreen;
import carbonconfiglib.impl.PerWorldProxy;
import carbonconfiglib.impl.internal.InternalFeatures;
import carbonconfiglib.impl.internal.ModConfigList;
import carbonconfiglib.impl.internal.ModConfigs;
import carbonconfiglib.networking.carbon.StateSyncPacket;
import carbonconfiglib.networking.snyc.BulkSyncPacket;
import carbonconfiglib.networking.snyc.SyncPacket;
import carbonconfiglib.plugins.ICarbonPlugin;
import carbonconfiglib.utils.SyncType;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.mclanguageprovider.MinecraftModContainer;
import net.minecraftforge.server.ServerLifecycleHooks;
import speiger.src.collections.objects.lists.ObjectArrayList;
import speiger.src.collections.objects.maps.impl.hash.Object2ObjectLinkedOpenHashMap;
import speiger.src.collections.objects.maps.interfaces.Object2ObjectMap;

public class EventHandler
implements IConfigChangeListener {
    public static final EventHandler INSTANCE = new EventHandler();
    Map<ModContainer, ModConfigs> configs = new Object2ObjectLinkedOpenHashMap().synchronize();

    @Override
    public void onConfigCreated(ConfigHandler config) {
        InternalFeatures.initMinecraftDataTypes(config);
        if (FMLEnvironment.dist.isDedicatedServer()) {
            return;
        }
        ModLoadingContext context = ModLoadingContext.get();
        if ("minecraft".equals(context.getActiveNamespace())) {
            if (FMLEnvironment.production) {
                return;
            }
            throw new IllegalStateException("Mod Configs Must be created (not loaded) during a Mod Loading Phase");
        }
        this.configs.computeIfAbsent(context.getActiveContainer(), ModConfigs::new).addConfig(config);
    }

    @Override
    public void onConfigAdded(ConfigHandler config) {
    }

    @Override
    public void onConfigChanged(ConfigHandler config) {
        SyncPacket packet;
        if (FMLEnvironment.dist.isDedicatedServer()) {
            SyncPacket packet2 = SyncPacket.create(config, SyncType.SERVER_TO_CLIENT, false);
            if (packet2 != null) {
                CarbonConfig.NETWORK.sendToAllPlayers(packet2);
            }
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && (packet = SyncPacket.create(config, SyncType.SERVER_TO_CLIENT, false)) != null) {
            CarbonConfig.NETWORK.sendToAllPlayers(packet);
        }
        if (CarbonConfig.NETWORK.isInWorld() && (packet = SyncPacket.create(config, SyncType.CLIENT_TO_SERVER, false)) != null) {
            CarbonConfig.NETWORK.sendToServer(packet);
        }
    }

    @Override
    public void onConfigErrored(ConfigHandler configHandler) {
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public void onServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.processEvents();
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.processEvents();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onConfigsLoaded() {
        InternalFeatures.loadDefaultTypes();
        Object2ObjectLinkedOpenHashMap mappedConfigs = new Object2ObjectLinkedOpenHashMap();
        this.configs.forEach((arg_0, arg_1) -> EventHandler.lambda$onConfigsLoaded$0((Object2ObjectMap)mappedConfigs, arg_0, arg_1));
        if (CarbonConfig.FORGE_SUPPORT.get()) {
            ModList.get().forEachModInOrder(arg_0 -> EventHandler.lambda$onConfigsLoaded$1((Object2ObjectMap)mappedConfigs, arg_0));
        }
        ICarbonPlugin.LOADED_PLUGINS.forEach((arg_0, arg_1) -> EventHandler.lambda$onConfigsLoaded$3((Object2ObjectMap)mappedConfigs, arg_0, arg_1));
        mappedConfigs.forEach((M, C) -> M.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((U, S) -> this.create((Screen)S, ModConfigList.createMultiIfApplicable(M, C)))));
    }

    @OnlyIn(value=Dist.CLIENT)
    private Screen create(Screen screen, IModConfigs configs) {
        return new ConfigSelectorScreen(configs, screen);
    }

    public void onServerJoinPacket(Player player) {
        CarbonConfig.NETWORK.sendToPlayer(new StateSyncPacket(Dist.DEDICATED_SERVER), player);
        CarbonConfig.NETWORK.onPlayerJoined(player, true);
        BulkSyncPacket packet = BulkSyncPacket.create(CarbonConfig.CONFIGS.getConfigsToSync(), SyncType.SERVER_TO_CLIENT, true);
        if (packet == null) {
            return;
        }
        CarbonConfig.NETWORK.sendToPlayer(packet, player);
    }

    @SubscribeEvent
    public void onServerLeaveEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        CarbonConfig.NETWORK.onPlayerLeft(event.getEntity(), true);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPlayerServerJoinEvent(ClientPlayerNetworkEvent.LoggingIn event) {
        if (Minecraft.m_91087_().m_91089_() == null) {
            this.loadMPConfigs();
        }
        CarbonConfig.NETWORK.sendToServer(new StateSyncPacket(Dist.CLIENT));
        BulkSyncPacket packet = BulkSyncPacket.create(CarbonConfig.CONFIGS.getConfigsToSync(), SyncType.CLIENT_TO_SERVER, true);
        if (packet == null) {
            return;
        }
        CarbonConfig.NETWORK.sendToServer(packet);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPlayerServerLeaveEvent(ClientPlayerNetworkEvent.LoggingOut event) {
        CarbonConfig.NETWORK.onPlayerLeft((Player)event.getPlayer(), false);
        if (!Minecraft.m_91087_().m_91090_()) {
            for (ConfigHandler handler : CarbonConfig.CONFIGS.getAllConfigs()) {
                if (!PerWorldProxy.isProxy(handler.getProxy())) continue;
                handler.unload();
            }
        }
    }

    private void loadMPConfigs() {
        for (ConfigHandler handler : CarbonConfig.CONFIGS.getAllConfigs()) {
            if (!PerWorldProxy.isProxy(handler.getProxy())) continue;
            handler.load();
        }
    }

    private void processEvents() {
        CarbonConfig.CONFIGS.processFileSystemEvents();
    }

    private static /* synthetic */ void lambda$onConfigsLoaded$3(Object2ObjectMap mappedConfigs, ModContainer K, ICarbonPlugin V) {
        ObjectArrayList configs = new ObjectArrayList();
        V.applyConfigs(K, ((List)configs)::add);
        if (configs.size() > 0) {
            ((List)mappedConfigs.computeIfAbsent((Object)K, T -> new ObjectArrayList())).addAll(configs);
        }
    }

    private static /* synthetic */ void lambda$onConfigsLoaded$1(Object2ObjectMap mappedConfigs, ModContainer T) {
        if (CarbonConfig.MODS_DISABLED.contains(T.getModId())) {
            return;
        }
        if (T.getCustomExtension(ConfigScreenHandler.ConfigScreenFactory.class).isEmpty()) {
            ForgeConfigs configs = new ForgeConfigs(T);
            if (configs.hasConfigs()) {
                ((List)mappedConfigs.supplyIfAbsent((Object)T, ObjectArrayList::new)).add(configs);
            } else if (T instanceof MinecraftModContainer) {
                ((List)mappedConfigs.supplyIfAbsent((Object)T, ObjectArrayList::new)).add(new MinecraftConfigs());
            }
        }
    }

    private static /* synthetic */ void lambda$onConfigsLoaded$0(Object2ObjectMap mappedConfigs, ModContainer M, ModConfigs C) {
        if (M.getCustomExtension(ConfigScreenHandler.ConfigScreenFactory.class).isPresent()) {
            return;
        }
        ((List)mappedConfigs.supplyIfAbsent((Object)M, ObjectArrayList::new)).add(C);
    }
}

