/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking.carbon;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.config.ConfigHandler;
import carbonconfiglib.networking.ICarbonPacket;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public class SaveConfigPacket
implements ICarbonPacket {
    String identifier;
    String data;

    public SaveConfigPacket() {
    }

    public SaveConfigPacket(String identifier, String data) {
        this.identifier = identifier;
        this.data = data;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130072_(this.identifier, Short.MAX_VALUE);
        buffer.m_130072_(this.data, 262144);
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.identifier = buffer.m_130136_(Short.MAX_VALUE);
        this.data = buffer.m_130136_(262144);
    }

    @Override
    public void process(Player player) {
        if (!CarbonConfig.hasPermission(player, 4)) {
            CarbonConfig.LOGGER.warn("Don't have Permission to Change configs");
            return;
        }
        ConfigHandler handler = CarbonConfig.CONFIGS.getConfig(this.identifier);
        if (handler == null) {
            return;
        }
        try {
            ConfigHandler.load(handler, handler.getConfig(), (List<String>)ObjectArrayList.wrap((Object[])this.data.split("\n")), false);
            handler.save();
            CarbonConfig.LOGGER.info("Saved [" + this.identifier + "] Config");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

