/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.screen;

import carbonconfiglib.gui.api.BackgroundTexture;
import carbonconfiglib.gui.api.IModConfig;
import carbonconfiglib.gui.config.ConfigElement;
import carbonconfiglib.gui.config.Element;
import carbonconfiglib.gui.config.ListScreen;
import carbonconfiglib.gui.screen.ConfigScreen;
import carbonconfiglib.gui.widgets.CarbonButton;
import carbonconfiglib.gui.widgets.GuiUtils;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.level.storage.LevelSummary;

public class SelectFileScreen
extends ListScreen {
    private static final Component TEXT = Component.m_237115_((String)"gui.carbonconfig.select_world");
    IModConfig config;
    Screen parent;

    public SelectFileScreen(Component name, BackgroundTexture.BackgroundHolder customTexture, Screen parent, IModConfig config) {
        super(name, customTexture);
        this.config = config;
        this.parent = parent;
    }

    @Override
    protected void collectElements(Consumer<Element> elements) {
        for (IModConfig.IConfigTarget target : this.config.getPotentialFiles()) {
            if (Files.notExists(target.getConfigFile(), new LinkOption[0]) && !this.config.canCreateConfigs()) continue;
            elements.accept(new WorldElement(target, this.config, this.parent, this.f_96539_));
        }
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        int x = this.f_96543_ / 2;
        int y = this.f_96544_;
        this.m_142416_((GuiEventListener)new CarbonButton(x - 80, y - 27, 160, 20, (Component)Component.m_237115_((String)"gui.carbonconfig.back"), T -> this.m_7379_()));
    }

    @Override
    protected int getElementHeight() {
        return 28;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    @Override
    public void m_86412_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        super.m_86412_(stack, mouseX, mouseY, partialTicks);
        this.f_96547_.m_92889_(stack, TEXT, (float)(this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)TEXT) / 2), 8.0f, -1);
    }

    @Override
    public void m_7861_() {
        this.allEntries.forEach(this::cleanup);
        super.m_7861_();
    }

    private void cleanup(Element element) {
        if (element instanceof WorldElement) {
            ((WorldElement)element).cleanup();
        }
    }

    private static class WorldElement
    extends Element {
        IModConfig config;
        IModConfig.IConfigTarget target;
        Screen parent;
        Button button;
        Component title;
        Component path;
        DynamicTexture texture;
        ConfigScreen.Navigator nav;

        public WorldElement(IModConfig.IConfigTarget target, IModConfig config, Screen parent, Component prevName) {
            super((Component)Component.m_237113_((String)target.getName()));
            this.nav = new ConfigScreen.Navigator(prevName);
            this.nav.setScreenForLayer(parent);
            this.target = target;
            this.config = config;
            this.parent = parent;
        }

        @Override
        public void init() {
            if (this.target instanceof IModConfig.WorldConfigTarget) {
                IModConfig.WorldConfigTarget world = (IModConfig.WorldConfigTarget)this.target;
                LevelSummary sum = world.getSummary();
                this.loadIcon(sum.m_230875_());
                this.title = Component.m_237113_((String)sum.m_78361_());
                this.path = Component.m_237113_((String)sum.m_78358_()).m_130940_(ChatFormatting.GRAY);
            } else {
                this.title = Component.m_237113_((String)this.target.getName());
                Path folder = this.target.getFolder();
                int index = folder.getNameCount();
                this.path = Component.m_237113_((String)folder.subpath(index - 3, index).toString()).m_130940_(ChatFormatting.GRAY);
            }
            boolean load = Files.exists(this.target.getConfigFile(), new LinkOption[0]);
            this.button = new CarbonButton(0, 0, 62, 20, (Component)Component.m_237115_((String)(load ? "gui.carbonconfig.pick" : "gui.carbonconfig.create")), this::onPick);
        }

        @Override
        public void m_6311_(PoseStack poseStack, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            this.button.m_252865_(left + width - 62);
            this.button.m_252888_(top + 2);
            this.button.m_86412_(poseStack, mouseX, mouseY, partialTicks);
            GuiUtils.drawScrollingString(poseStack, this.font, this.title, left + 5, top + 2, 150.0f, 10.0f, ConfigElement.GuiAlign.LEFT, -1, 0);
            GuiUtils.drawScrollingString(poseStack, this.font, this.path, left + 5, top + 12, 150.0f, 10.0f, ConfigElement.GuiAlign.LEFT, -1, 0);
            if (this.texture != null) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157453_((int)0, (int)this.texture.m_117963_());
                GuiUtils.drawTextureRegion(poseStack, left - 24, top, 0.0f, 0.0f, 24.0f, 24.0f, 64.0f, 64.0f, 64.0f, 64.0f);
            }
        }

        private void loadIcon(Path iconFile) {
            try (InputStream stream = Files.newInputStream(iconFile, new OpenOption[0]);){
                NativeImage image = NativeImage.m_85058_((InputStream)stream);
                if (image == null || image.m_84982_() != 64 || image.m_85084_() != 64) {
                    return;
                }
                this.texture = new DynamicTexture(image);
                this.texture.m_117985_();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public List<? extends GuiEventListener> m_6702_() {
            return ObjectLists.singleton((Object)this.button);
        }

        private void onPick(Button button) {
            Path file = this.target.getConfigFile();
            if (Files.notExists(file, new LinkOption[0]) && !this.config.createConfig(file)) {
                return;
            }
            IModConfig config = this.config.loadFromFile(file);
            if (config == null) {
                this.mc.m_91152_(this.parent);
                return;
            }
            this.mc.m_91152_((Screen)new ConfigScreen(this.nav.add((Component)this.path.m_6881_().m_130940_(ChatFormatting.WHITE)), config, this.parent, this.owner.getCustomTexture()));
        }

        private void cleanup() {
            if (this.texture == null) {
                return;
            }
            this.texture.close();
            this.texture = null;
        }
    }
}

