/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking.snyc;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.config.ConfigEntry;
import carbonconfiglib.config.ConfigHandler;
import carbonconfiglib.impl.ReloadMode;
import carbonconfiglib.networking.ICarbonPacket;
import carbonconfiglib.networking.buffer.ReadBuffer;
import carbonconfiglib.networking.buffer.WriteBuffer;
import carbonconfiglib.utils.SyncType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public class SyncPacket
implements ICarbonPacket {
    String identifier;
    SyncType type;
    Map<String, byte[]> entries = new Object2ObjectLinkedOpenHashMap();

    public SyncPacket() {
    }

    public SyncPacket(String identifier, SyncType type, Map<String, byte[]> entries) {
        this.identifier = identifier;
        this.type = type;
        this.entries = entries;
    }

    public static SyncPacket create(ConfigHandler handler, SyncType type, boolean forceSync) {
        if (!handler.isLoaded()) {
            return null;
        }
        Object2ObjectLinkedOpenHashMap data = new Object2ObjectLinkedOpenHashMap();
        ByteBuf buf = Unpooled.buffer();
        WriteBuffer buffer = new WriteBuffer(new FriendlyByteBuf(buf));
        for (Map.Entry<String, ConfigEntry<?>> entry : handler.getConfig().getSyncedEntries(type).entrySet()) {
            ConfigEntry<?> value = entry.getValue();
            if (!forceSync && !value.hasChanged()) continue;
            buf.clear();
            value.serialize(buffer);
            byte[] configData = new byte[buf.writerIndex()];
            buf.readBytes(configData);
            data.put(entry.getKey(), configData);
            value.onSynced();
        }
        return data.isEmpty() ? null : new SyncPacket(handler.getConfigIdentifer(), type, (Map<String, byte[]>)data);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.identifier);
        buffer.m_130068_((Enum)this.type);
        buffer.m_130130_(this.entries.size());
        for (Map.Entry<String, byte[]> entry : this.entries.entrySet()) {
            buffer.m_130070_(entry.getKey());
            buffer.m_130087_(entry.getValue());
        }
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.identifier = buffer.m_130136_(Short.MAX_VALUE);
        this.type = (SyncType)buffer.m_130066_(SyncType.class);
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            this.entries.put(buffer.m_130136_(Short.MAX_VALUE), buffer.m_130052_());
        }
    }

    @Override
    public void process(Player player) {
        ReloadMode mode = this.processEntry(player);
        if (mode != null) {
            player.m_213846_(mode.getMessage());
        }
    }

    public ReloadMode processEntry(Player player) {
        if (this.entries.isEmpty()) {
            return null;
        }
        ConfigHandler cfg = CarbonConfig.CONFIGS.getConfig(this.identifier);
        if (cfg == null) {
            CarbonConfig.LOGGER.warn("Received packet for [" + this.identifier + "] which didn't exist!");
            return null;
        }
        Map<String, ConfigEntry<?>> mapped = cfg.getConfig().getSyncedEntries(this.type);
        boolean hasChanged = false;
        UUID owner = player.m_20148_();
        ReloadMode mode = null;
        for (Map.Entry<String, byte[]> dataEntry : this.entries.entrySet()) {
            ConfigEntry<?> entry = mapped.get(dataEntry.getKey());
            if (entry == null) continue;
            entry.deserialize(new ReadBuffer(new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])dataEntry.getValue()))), owner);
            if (entry.hasChanged()) {
                hasChanged = true;
                mode = ReloadMode.or(mode, entry.getReloadState());
            }
            entry.onSynced();
        }
        if (hasChanged) {
            cfg.onSynced();
            cfg.saveQuietly();
            return mode;
        }
        return null;
    }
}

