/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.plugins.jei.configs;

import carbonconfiglib.api.ConfigType;
import carbonconfiglib.gui.api.BackgroundTexture;
import carbonconfiglib.gui.api.IModConfig;
import carbonconfiglib.gui.api.IModConfigs;
import carbonconfiglib.impl.internal.ModConfigs;
import carbonconfiglib.plugins.jei.configs.JEIConfig;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.runtime.config.IJeiConfigFile;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import speiger.src.collections.objects.lists.ObjectArrayList;
import speiger.src.collections.objects.utils.ObjectLists;

public class JEIConfigs
implements IModConfigs {
    ModContainer container;
    List<IJeiConfigFile> configs;

    public JEIConfigs(ModContainer container, List<IJeiConfigFile> configs) {
        this.container = container;
        this.configs = configs;
    }

    @Override
    public String getModName() {
        return "Jei";
    }

    @Override
    public List<IModConfig> getConfigInstances(ConfigType type) {
        if (type != ConfigType.CLIENT) {
            return ObjectLists.empty();
        }
        ObjectArrayList config = new ObjectArrayList();
        for (IJeiConfigFile file : this.configs) {
            config.add(new JEIConfig(file));
        }
        return config;
    }

    @Override
    public BackgroundTexture.BackgroundHolder getBackground() {
        Optional texture = this.container.getCustomExtension(IModConfigs.Background.class);
        if (texture.isPresent()) {
            return ((IModConfigs.Background)texture.get()).texture().asHolder();
        }
        Optional<BackgroundTexture> carbon_Texture = ModConfigs.computeTexture(this.container);
        if (carbon_Texture.isPresent()) {
            return carbon_Texture.get().asHolder();
        }
        return JEIConfigs.getBackgroundTexture(this.container.getModInfo()).asHolder();
    }

    private static BackgroundTexture getBackgroundTexture(IModInfo info) {
        Optional optional;
        String configBackground = (String)info.getModProperties().get("configuredBackground");
        if (configBackground != null) {
            return BackgroundTexture.of(configBackground).build();
        }
        if (info instanceof ModInfo && (optional = ((ModInfo)info).getConfigElement(new String[]{"configBackground"})).isPresent()) {
            return BackgroundTexture.of((String)optional.get()).build();
        }
        return BackgroundTexture.DEFAULT;
    }
}

