/*
 * Decompiled with CFR 0.152.
 */
package dev.microcontrollers.rendertweaks.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Cancellable;
import com.llamalad7.mixinextras.sugar.Local;
import dev.microcontrollers.rendertweaks.config.RenderTweaksConfig;
import dev.microcontrollers.rendertweaks.util.ColorUtil;
import java.awt.Color;
import net.minecraft.class_2784;
import net.minecraft.class_9978;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_9978.class})
public class LevelRendererMixin {
    @Unique
    private static final RenderTweaksConfig config = (RenderTweaksConfig)RenderTweaksConfig.CONFIG.instance();

    @ModifyExpressionValue(method={"extract"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/border/BorderStatus;getColor()I")})
    private int changeWorldBorderColor(int original, @Local(ordinal=0, argsOnly=true) class_2784 worldBorder, @Cancellable CallbackInfo ci) {
        return switch (worldBorder.method_11968().name()) {
            case "STATIONARY" -> {
                if (LevelRendererMixin.config.disableWorldBorderStationary || LevelRendererMixin.config.worldBorderStationaryColor.getAlpha() == 0 || LevelRendererMixin.config.worldBorderStationaryAlpha == 0.0f) {
                    ci.cancel();
                }
                Color color = ColorUtil.getColor(LevelRendererMixin.config.worldBorderStationaryChroma, LevelRendererMixin.config.worldBorderStationaryColor, LevelRendererMixin.config.worldBorderStationarySpeed, LevelRendererMixin.config.worldBorderStationarySaturation, LevelRendererMixin.config.worldBorderStationaryBrightness, LevelRendererMixin.config.worldBorderStationaryAlpha);
                yield color.getRGB();
            }
            case "SHRINKING" -> {
                if (LevelRendererMixin.config.disableWorldBorderShrinking || LevelRendererMixin.config.worldBorderShrinkingColor.getAlpha() == 0 || LevelRendererMixin.config.worldBorderShrinkingAlpha == 0.0f) {
                    ci.cancel();
                }
                Color color = ColorUtil.getColor(LevelRendererMixin.config.worldBorderShrinkingChroma, LevelRendererMixin.config.worldBorderShrinkingColor, LevelRendererMixin.config.worldBorderShrinkingSpeed, LevelRendererMixin.config.worldBorderShrinkingSaturation, LevelRendererMixin.config.worldBorderShrinkingBrightness, LevelRendererMixin.config.worldBorderShrinkingAlpha);
                yield color.getRGB();
            }
            case "GROWING" -> {
                if (LevelRendererMixin.config.disableWorldBorderGrowing || LevelRendererMixin.config.worldBorderGrowingColor.getAlpha() == 0 || LevelRendererMixin.config.worldBorderGrowingAlpha == 0.0f) {
                    ci.cancel();
                }
                Color color = ColorUtil.getColor(LevelRendererMixin.config.worldBorderGrowingChroma, LevelRendererMixin.config.worldBorderGrowingColor, LevelRendererMixin.config.worldBorderGrowingSpeed, LevelRendererMixin.config.worldBorderGrowingSaturation, LevelRendererMixin.config.worldBorderGrowingBrightness, LevelRendererMixin.config.worldBorderGrowingAlpha);
                yield color.getRGB();
            }
            default -> original;
        };
    }
}

