/*
 * Decompiled with CFR 0.152.
 */
package dev.microcontrollers.rendertweaks.mixin;

import dev.microcontrollers.rendertweaks.config.RenderTweaksConfig;
import dev.microcontrollers.rendertweaks.util.ColorUtil;
import java.awt.Color;
import net.minecraft.class_4588;
import net.minecraft.class_919;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={class_919.class})
public class LightningBoltRendererMixin {
    @Unique
    private static final RenderTweaksConfig config = (RenderTweaksConfig)RenderTweaksConfig.CONFIG.instance();

    @Inject(method={"quad"}, at={@At(value="HEAD")}, cancellable=true)
    private static void cancelLightningRendering(Matrix4f pose, class_4588 buffer, float x1, float z1, int sectionY, float x2, float z2, float red, float green, float blue, float innerThickness, float outerThickness, boolean addThicknessLeftSideX, boolean addThicknessLeftSideZ, boolean addThicknessRightSideX, boolean addThicknessRightSideZ, CallbackInfo ci) {
        if (LightningBoltRendererMixin.config.disableLightning || LightningBoltRendererMixin.config.lightningAlpha == 0.0f || LightningBoltRendererMixin.config.lightningColor.getAlpha() == 0) {
            ci.cancel();
        }
    }

    @ModifyArgs(method={"quad"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/VertexConsumer;setColor(FFFF)Lcom/mojang/blaze3d/vertex/VertexConsumer;"))
    private static void changeLightningColors(Args args) {
        Color color = ColorUtil.getColor(LightningBoltRendererMixin.config.lightningChroma, LightningBoltRendererMixin.config.lightningColor, LightningBoltRendererMixin.config.lightningSpeed, LightningBoltRendererMixin.config.lightningSaturation, LightningBoltRendererMixin.config.lightningBrightness, LightningBoltRendererMixin.config.lightningAlpha);
        args.set(0, (Object)Float.valueOf((float)color.getRed() / 255.0f));
        args.set(1, (Object)Float.valueOf((float)color.getGreen() / 255.0f));
        args.set(2, (Object)Float.valueOf((float)color.getBlue() / 255.0f));
        args.set(3, (Object)Float.valueOf((float)color.getAlpha() / 255.0f));
    }
}

