/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.noise;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.mod.noise.CellularNoise2D;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import org.jetbrains.annotations.NotNull;

public class CellularBiomeSource
extends BiomeSource {
    public static final MapCodec<CellularBiomeSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(source -> source.allowedBiomes), (App)Codec.LONG.fieldOf("seed").forGetter(source -> source.seed), (App)Codec.DOUBLE.fieldOf("scale").orElse((Object)0.1).forGetter(source -> source.scale)).apply((Applicative)instance, CellularBiomeSource::new));
    private final HolderSet<Biome> allowedBiomes;
    private final Long seed;
    private final double scale;
    private final CellularNoise2D noiseGenerator;

    public CellularBiomeSource(HolderSet<Biome> allowedBiomes, long seed, double scale) {
        this.allowedBiomes = allowedBiomes;
        this.seed = seed;
        this.scale = scale;
        this.noiseGenerator = new CellularNoise2D(seed);
    }

    @NotNull
    protected Stream<Holder<Biome>> m_274359_() {
        return this.allowedBiomes.m_203614_();
    }

    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC.codec();
    }

    @NotNull
    public Holder<Biome> m_203407_(int x, int y, int z, Climate.Sampler sampler) {
        double noiseValue = this.noiseGenerator.getNoise((double)x * this.scale, (double)z * this.scale);
        double normalizedNoise = (noiseValue + 1.0) / 2.0;
        int biomeIndex = (int)Math.floor(normalizedNoise * (double)this.allowedBiomes.m_203632_());
        if (biomeIndex >= this.allowedBiomes.m_203632_()) {
            biomeIndex = this.allowedBiomes.m_203632_() - 1;
        }
        return this.allowedBiomes.m_203662_(biomeIndex);
    }
}

