/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.noise;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.mod.noise.CellularNoise2D;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import org.jetbrains.annotations.NotNull;

public class CellularBiomeSource
extends BiomeSource {
    public static final MapCodec<CellularBiomeSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(source -> source.allowedBiomes), (App)Codec.LONG.fieldOf("seed").forGetter(source -> source.seed), (App)Codec.DOUBLE.fieldOf("scale").orElse((Object)0.1).forGetter(source -> source.scale)).apply((Applicative)instance, CellularBiomeSource::new));
    private final HolderSet<Biome> allowedBiomes;
    private final Supplier<List<Holder<Biome>>> biomesList;
    private final Long seed;
    private final double scale;
    private final CellularNoise2D noiseGenerator;

    public CellularBiomeSource(HolderSet<Biome> allowedBiomes, long seed, double scale) {
        this.allowedBiomes = allowedBiomes;
        this.biomesList = Suppliers.memoize(() -> allowedBiomes.stream().toList());
        this.seed = seed;
        this.scale = scale;
        this.noiseGenerator = new CellularNoise2D(seed);
    }

    @NotNull
    protected Stream<Holder<Biome>> collectPossibleBiomes() {
        return this.allowedBiomes.stream();
    }

    @NotNull
    protected MapCodec<? extends BiomeSource> codec() {
        return CODEC;
    }

    @NotNull
    public Holder<Biome> getNoiseBiome(int x, int y, int z, Climate.Sampler sampler) {
        int count;
        List<Holder<Biome>> biomes = this.biomesList.get();
        if (biomes.isEmpty()) {
            throw new IllegalStateException("CellularBiomeSource has no biomes!");
        }
        double noiseValue = this.noiseGenerator.getNoise((double)x * this.scale, (double)z * this.scale);
        double normalizedNoise = (noiseValue + 1.0) / 2.0;
        int biomeIndex = (int)Math.floor(normalizedNoise * (double)(count = biomes.size()));
        if (biomeIndex >= count) {
            biomeIndex = count - 1;
        }
        return biomes.get(biomeIndex);
    }
}

